/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.common.shared.security;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoHelper.class);
    static final int KEY_AND_NONCE_AND_IV_LENGTH_IN_BYTES = 16;
    private static final String UTF8 = "UTF-8";
    private static final String CIPHER_SUITE = "AES/CBC/PKCS5Padding";
    private static final int PADDED_LENGTH = 528;
    private final SecretKeySpec aesKey;
    private final SecureRandom random;
    private IvParameterSpec iv;

    public CryptoHelper(String base64EncodedAesKey) {
        byte[] bytes = this.unBase64(base64EncodedAesKey);
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Incorrect key length");
        }
        this.aesKey = new SecretKeySpec(bytes, "AES");
        this.random = new SecureRandom();
        byte[] ivBytes = this.getInitializationVector();
        this.iv = new IvParameterSpec(ivBytes);
    }

    public Optional<String> encrypt_yesIKnowThisCryptoCodeHasNotBeenAudited(String idpEntityId) {
        byte[] encryptedIdpNameWithNonce;
        byte[] idpEntityIdAsByteArray;
        try {
            idpEntityIdAsByteArray = this.bytes(idpEntityId);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn(MessageFormat.format("UnsupportedEncoding (not UTF8) for entityId: {0}", idpEntityId));
            return Optional.empty();
        }
        byte[] decryptedIdpNameWithNonce = this.addNonceAndPadding(idpEntityIdAsByteArray);
        try {
            encryptedIdpNameWithNonce = this.encrypt(decryptedIdpNameWithNonce);
        }
        catch (GeneralSecurityException e) {
            LOG.warn(MessageFormat.format("Unable to encode: {0}, exception message: {1}", decryptedIdpNameWithNonce, e.getMessage()));
            return Optional.empty();
        }
        return Optional.of(this.base64(encryptedIdpNameWithNonce));
    }

    public Optional<String> decrypt_yesIKnowThisCryptoCodeHasNotBeenAudited(String base64EncodedEncryptedIdpNameWithNonce) {
        byte[] decryptedIdpNameWithNonce;
        if (base64EncodedEncryptedIdpNameWithNonce.isEmpty()) {
            LOG.warn("entityId is empty");
            return Optional.empty();
        }
        byte[] encryptedIdpNameWithNonce = this.unBase64(base64EncodedEncryptedIdpNameWithNonce);
        try {
            decryptedIdpNameWithNonce = this.decrypt(encryptedIdpNameWithNonce);
        }
        catch (BadPaddingException e) {
            LOG.warn(MessageFormat.format("BadPadding (possibly incorrect key) trying to decrypt message: {0}", new Object[]{encryptedIdpNameWithNonce}));
            return Optional.empty();
        }
        catch (InvalidKeyException e) {
            LOG.warn(MessageFormat.format("Key is invalid for message: {0}", new Object[]{encryptedIdpNameWithNonce}));
            return Optional.empty();
        }
        catch (GeneralSecurityException e) {
            LOG.warn(MessageFormat.format("Failed to decrypt message: {0}", new Object[]{encryptedIdpNameWithNonce}));
            return Optional.empty();
        }
        byte[] idpEntityIdAsByteArray = this.removeNonceAndPadding(decryptedIdpNameWithNonce);
        try {
            return Optional.of(this.string(idpEntityIdAsByteArray));
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn(MessageFormat.format("UnsupportedEncoding (UTF8) could not encode entityId as utf8: {0}", new Object[]{idpEntityIdAsByteArray}));
            return Optional.empty();
        }
    }

    private byte[] unBase64(String data) {
        return DatatypeConverter.parseBase64Binary((String)data);
    }

    private String base64(byte[] data) {
        return DatatypeConverter.printBase64Binary((byte[])data);
    }

    private byte[] bytes(String string) throws UnsupportedEncodingException {
        return string.getBytes(UTF8);
    }

    private String string(byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes, UTF8);
    }

    private byte[] addNonceAndPadding(byte[] withoutNonce) {
        int lenWithNonce = withoutNonce.length + 16;
        if (lenWithNonce > 528) {
            throw new IllegalArgumentException("That's a very long IDP entityId!");
        }
        byte[] withNonceAndPadding = new byte[528];
        System.arraycopy(this.newNonce(), 0, withNonceAndPadding, 0, 16);
        System.arraycopy(withoutNonce, 0, withNonceAndPadding, 16, withoutNonce.length);
        return withNonceAndPadding;
    }

    private byte[] removeNonceAndPadding(byte[] withNonce) {
        int paddingStart;
        for (paddingStart = 16; paddingStart < withNonce.length && withNonce[paddingStart] != 0; ++paddingStart) {
        }
        int lenWithoutNonceOrPadding = paddingStart - 16;
        byte[] withoutNonceOrPadding = new byte[lenWithoutNonceOrPadding];
        System.arraycopy(withNonce, 16, withoutNonceOrPadding, 0, withoutNonceOrPadding.length);
        return withoutNonceOrPadding;
    }

    private byte[] encrypt(byte[] plaintext) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(CIPHER_SUITE);
        cipher.init(1, (Key)this.aesKey, this.iv);
        return cipher.doFinal(plaintext);
    }

    private byte[] decrypt(byte[] ciphertext) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(CIPHER_SUITE);
        cipher.init(2, (Key)this.aesKey, this.iv);
        return cipher.doFinal(ciphertext);
    }

    private byte[] getInitializationVector() {
        return this.newNonce();
    }

    private byte[] newNonce() {
        byte[] nonce = new byte[16];
        this.random.nextBytes(nonce);
        return nonce;
    }
}

