/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.common.shared.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import uk.gov.ida.common.shared.configuration.KeyConfiguration;
import uk.gov.ida.common.shared.configuration.SecureCookieKeyConfiguration;
import uk.gov.ida.common.shared.configuration.SecureCookieKeyStore;
import uk.gov.ida.common.shared.security.FileUtils;

public class SecureCookieKeyConfigurationKeyStore
implements SecureCookieKeyStore {
    private KeyConfiguration keyConfiguration;

    @Inject
    public SecureCookieKeyConfigurationKeyStore(@SecureCookieKeyConfiguration KeyConfiguration keyConfiguration) {
        this.keyConfiguration = keyConfiguration;
    }

    @Override
    public Key getKey() {
        String keyUri = this.keyConfiguration.getKeyUri();
        try {
            return SecureCookieKeyConfigurationKeyStore.getSecureCookieKey(keyUri);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private static Key getSecureCookieKey(String keyUri) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        try (FileInputStream inputStream = new FileInputStream(new File(keyUri));){
            byte[] ous = FileUtils.readStream(inputStream);
            SecretKeySpec secretKeySpec = new SecretKeySpec(ous, "HmacSHA1");
            return secretKeySpec;
        }
    }
}

