/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata.test.factories.metadata;

import com.google.common.base.Throwables;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.gov.ida.saml.metadata.test.factories.metadata.EntitiesDescriptorFactory;
import uk.gov.ida.shared.utils.xml.XmlUtils;

public class MetadataFactory {
    private final EntitiesDescriptorFactory entitiesDescriptorFactory = new EntitiesDescriptorFactory();

    public String defaultMetadata() {
        return this.metadata(this.entitiesDescriptorFactory.defaultEntitiesDescriptor());
    }

    public String emptyMetadata() {
        return this.metadata(this.entitiesDescriptorFactory.emptyEntitiesDescriptor());
    }

    public String metadata(EntitiesDescriptor entitiesDescriptor) {
        return XmlUtils.writeToString((Node)this.transform((SAMLObject)entitiesDescriptor));
    }

    public String metadata(List<EntityDescriptor> entityDescriptors) {
        return this.metadata(this.entitiesDescriptorFactory.entitiesDescriptor(entityDescriptors));
    }

    public String singleEntityMetadata(EntityDescriptor entityDescriptor) {
        return XmlUtils.writeToString((Node)this.transform((SAMLObject)entityDescriptor));
    }

    public String expiredMetadata() {
        return this.metadata(this.entitiesDescriptorFactory.expiredEntitiesDescriptor());
    }

    public String unsignedMetadata() {
        return this.metadata(this.entitiesDescriptorFactory.unsignedEntitiesDescriptor());
    }

    public String signedMetadata(String publicCertificate, String privateKey) {
        return this.metadata(this.entitiesDescriptorFactory.signedEntitiesDescriptor(publicCertificate, privateKey));
    }

    public String metadataWithFullCertificateChain(String publicCertificate, List<String> certificateChain, String privateKey) {
        return this.metadata(this.entitiesDescriptorFactory.fullChainSignedEntitiesDescriptor(publicCertificate, certificateChain, privateKey));
    }

    private Element transform(SAMLObject entitiesDescriptor) {
        Element result;
        try {
            this.marshallToXml(entitiesDescriptor);
            result = entitiesDescriptor.getDOM();
        }
        catch (ParserConfigurationException | MarshallingException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return result;
    }

    private Document marshallToXml(SAMLObject samlXml) throws ParserConfigurationException, MarshallingException {
        MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
        Marshaller responseMarshaller = marshallerFactory.getMarshaller((XMLObject)samlXml);
        Document document = XmlUtils.newDocumentBuilder().newDocument();
        responseMarshaller.marshall((XMLObject)samlXml, document);
        return document;
    }
}

