/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders.metadata;

import java.util.Optional;
import org.opensaml.xmlsec.signature.X509Certificate;
import uk.gov.ida.saml.core.test.TestCertificateStrings;

public class X509CertificateBuilder {
    private Optional<String> cert = Optional.empty();
    private Optional<String> certForEntityId = Optional.ofNullable("https://signin.service.gov.uk");

    public static X509CertificateBuilder aX509Certificate() {
        return new X509CertificateBuilder();
    }

    public X509Certificate build() {
        X509Certificate x509Certificate = new org.opensaml.xmlsec.signature.impl.X509CertificateBuilder().buildObject();
        if (this.cert.isPresent()) {
            x509Certificate.setValue(this.cert.get());
        } else if (this.certForEntityId.isPresent()) {
            x509Certificate.setValue(this.getCertForEntity());
        }
        return x509Certificate;
    }

    private String getCertForEntity() {
        return (String)TestCertificateStrings.PUBLIC_SIGNING_CERTS.get(this.certForEntityId.get());
    }

    public X509CertificateBuilder withCert(String cert) {
        this.cert = Optional.ofNullable(cert);
        return this;
    }

    public X509CertificateBuilder withCertForEntityId(String entityId) {
        this.certForEntityId = Optional.ofNullable(entityId);
        return this;
    }
}

