/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.algorithm.DigestAlgorithm;
import org.opensaml.xmlsec.algorithm.SignatureAlgorithm;
import org.opensaml.xmlsec.algorithm.descriptors.DigestSHA256;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA256;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.support.DocumentInternalIDContentReference;
import uk.gov.ida.saml.core.test.TestCertificateStrings;
import uk.gov.ida.saml.core.test.TestCredentialFactory;
import uk.gov.ida.saml.core.test.builders.metadata.KeyInfoBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.X509CertificateBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.X509DataBuilder;

public class SignatureBuilder {
    private Credential signingCredential = new TestCredentialFactory(TestCertificateStrings.TEST_PUBLIC_CERT, TestCertificateStrings.TEST_PRIVATE_KEY).getSigningCredential();
    private String id = null;
    private SignatureAlgorithm signatureAlgorithm = new SignatureRSASHA256();
    private DigestAlgorithm digestAlgorithm = new DigestSHA256();
    private List<String> x509Data = new ArrayList<String>();

    public static SignatureBuilder aSignature() {
        return new SignatureBuilder();
    }

    public SignatureBuilder withSigningCredential(Credential signingCredential) {
        if (signingCredential != null) {
            this.signingCredential = signingCredential;
        }
        return this;
    }

    public SignatureBuilder withSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        if (signatureAlgorithm != null) {
            this.signatureAlgorithm = signatureAlgorithm;
        }
        return this;
    }

    public SignatureBuilder withDigestAlgorithm(@NotNull String id, @NotNull DigestAlgorithm digestAlgorithm) {
        this.id = id;
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }

    public SignatureBuilder withX509Data(String publicCertificate) {
        this.x509Data.add(publicCertificate);
        return this;
    }

    public SignatureBuilder withX509Data(List<String> publicCertificate) {
        this.x509Data.addAll(publicCertificate);
        return this;
    }

    public Signature build() {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        XMLObjectBuilder signatureBuilder = builderFactory.getBuilderOrThrow(Signature.DEFAULT_ELEMENT_NAME);
        Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential(this.signingCredential);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setSignatureAlgorithm(this.signatureAlgorithm.getURI());
        if (this.id != null) {
            DocumentInternalIDContentReference contentReference = new DocumentInternalIDContentReference(this.id);
            contentReference.getTransforms().add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            contentReference.getTransforms().add("http://www.w3.org/2001/10/xml-exc-c14n#");
            contentReference.setDigestAlgorithm(this.digestAlgorithm.getURI());
            signature.getContentReferences().add(contentReference);
        }
        if (!this.x509Data.isEmpty()) {
            X509CertificateBuilder x509CertificateBuilder = X509CertificateBuilder.aX509Certificate();
            this.x509Data.forEach(x509CertificateBuilder::withCert);
            List<X509Certificate> certs = this.x509Data.stream().map(cert -> X509CertificateBuilder.aX509Certificate().withCert((String)cert).build()).collect(Collectors.toList());
            signature.setKeyInfo(new KeyInfoBuilder().withX509Data(new X509DataBuilder().withX509Certificates(certs).build()).build());
        }
        return signature;
    }
}

