/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders.metadata;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.KeyInfo;
import uk.gov.ida.saml.core.test.builders.metadata.KeyInfoBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.X509CertificateBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.X509DataBuilder;

public class KeyDescriptorBuilder {
    private String use = "SIGNING";
    private Optional<KeyInfo> keyInfo = Optional.ofNullable(KeyInfoBuilder.aKeyInfo().build());

    public static KeyDescriptorBuilder aKeyDescriptor() {
        return new KeyDescriptorBuilder();
    }

    public KeyDescriptor build() {
        KeyDescriptor keyDescriptor = new org.opensaml.saml.saml2.metadata.impl.KeyDescriptorBuilder().buildObject();
        if (this.keyInfo.isPresent()) {
            keyDescriptor.setKeyInfo(this.keyInfo.get());
        }
        keyDescriptor.setUse(UsageType.valueOf((String)this.use));
        return keyDescriptor;
    }

    public KeyDescriptorBuilder withUse(String use) {
        Preconditions.checkNotNull((Object)use);
        this.use = use;
        return this;
    }

    public KeyDescriptorBuilder withKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = Optional.ofNullable(keyInfo);
        return this;
    }

    public KeyDescriptorBuilder withX509ForSigning(String certificateValue) {
        this.withUse("SIGNING");
        return this.withKeyInfo(KeyInfoBuilder.aKeyInfo().withX509Data(X509DataBuilder.aX509Data().withX509Certificate(X509CertificateBuilder.aX509Certificate().withCert(certificateValue).build()).build()).build());
    }

    public KeyDescriptorBuilder withX509ForEncryption(String certificateValue) {
        this.withUse("ENCRYPTION");
        return this.withKeyInfo(KeyInfoBuilder.aKeyInfo().withX509Data(X509DataBuilder.aX509Data().withX509Certificate(X509CertificateBuilder.aX509Certificate().withCert(certificateValue).build()).build()).build());
    }
}

