/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;

public class EntitiesDescriptorBuilder {
    private String name = "VERIFY-FEDERATION";
    private List<EntityDescriptor> entityDescriptors = new ArrayList<EntityDescriptor>();
    private Optional<Signature> signature = Optional.empty();
    private String id = UUID.randomUUID().toString();
    private Optional<DateTime> validUntil = Optional.empty();
    private Optional<Long> cacheDuration = Optional.empty();

    public static EntitiesDescriptorBuilder anEntitiesDescriptor() {
        return new EntitiesDescriptorBuilder();
    }

    public EntitiesDescriptorBuilder withEntityDescriptors(List<EntityDescriptor> entityDescriptors) {
        this.entityDescriptors = entityDescriptors;
        return this;
    }

    public EntitiesDescriptorBuilder withSignature(Signature signature) {
        this.signature = Optional.of(signature);
        return this;
    }

    public EntitiesDescriptorBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public EntitiesDescriptorBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public EntitiesDescriptorBuilder withValidUntil(DateTime validUntil) {
        this.validUntil = Optional.of(validUntil);
        return this;
    }

    public EntitiesDescriptorBuilder withCacheDuration(Long cacheDuration) {
        this.cacheDuration = Optional.of(cacheDuration);
        return this;
    }

    public EntitiesDescriptor build() throws MarshallingException, SignatureException {
        EntitiesDescriptor entitiesDescriptor = new org.opensaml.saml.saml2.metadata.impl.EntitiesDescriptorBuilder().buildObject();
        entitiesDescriptor.getEntityDescriptors().addAll(this.entityDescriptors);
        entitiesDescriptor.setID(this.id);
        entitiesDescriptor.setName(this.name);
        this.validUntil.ifPresent(arg_0 -> ((EntitiesDescriptor)entitiesDescriptor).setValidUntil(arg_0));
        this.cacheDuration.ifPresent(arg_0 -> ((EntitiesDescriptor)entitiesDescriptor).setCacheDuration(arg_0));
        if (this.signature.isPresent()) {
            entitiesDescriptor.setSignature(this.signature.get());
            XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)entitiesDescriptor).marshall((XMLObject)entitiesDescriptor);
            Signer.signObject((Signature)entitiesDescriptor.getSignature());
        }
        return entitiesDescriptor;
    }
}

