/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opensaml.saml.saml2.metadata.Company;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.SurName;
import org.opensaml.saml.saml2.metadata.TelephoneNumber;
import uk.gov.ida.saml.core.test.builders.metadata.CompanyBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.EmailAddressBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.GivenNameBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.SurNameBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.TelephoneNumberBuilder;

public class ContactPersonBuilder {
    private Optional<GivenName> givenName = Optional.ofNullable(GivenNameBuilder.aGivenName().build());
    private Optional<Company> company = Optional.ofNullable(CompanyBuilder.aCompany().build());
    private Optional<SurName> surName = Optional.ofNullable(SurNameBuilder.aSurName().build());
    private List<EmailAddress> emailAddresses = new ArrayList<EmailAddress>();
    private boolean addDefaultEmailAddress = true;
    private List<TelephoneNumber> telephoneNumbers = new ArrayList<TelephoneNumber>();
    private boolean addDefaultTelephoneNumber = true;

    public static ContactPersonBuilder aContactPerson() {
        return new ContactPersonBuilder();
    }

    public ContactPerson build() {
        ContactPerson contactPerson = new org.opensaml.saml.saml2.metadata.impl.ContactPersonBuilder().buildObject();
        if (this.givenName.isPresent()) {
            contactPerson.setGivenName(this.givenName.get());
        }
        if (this.surName.isPresent()) {
            contactPerson.setSurName(this.surName.get());
        }
        if (this.company.isPresent()) {
            contactPerson.setCompany(this.company.get());
        }
        if (this.addDefaultEmailAddress) {
            this.emailAddresses.add(EmailAddressBuilder.anEmailAddress().build());
        }
        contactPerson.getEmailAddresses().addAll(this.emailAddresses);
        if (this.addDefaultTelephoneNumber) {
            this.telephoneNumbers.add(TelephoneNumberBuilder.aTelephoneNumber().build());
        }
        contactPerson.getTelephoneNumbers().addAll(this.telephoneNumbers);
        return contactPerson;
    }

    public ContactPersonBuilder withCompany(Company company) {
        this.company = Optional.ofNullable(company);
        return this;
    }

    public ContactPersonBuilder addEmailAddress(EmailAddress emailAddress) {
        this.emailAddresses.add(emailAddress);
        this.addDefaultEmailAddress = false;
        return this;
    }

    public ContactPersonBuilder addTelephoneNumber(TelephoneNumber number) {
        this.telephoneNumbers.add(number);
        this.addDefaultTelephoneNumber = false;
        return this;
    }
}

