/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;

public class SubjectConfirmationDataBuilder {
    public static final int NOT_ON_OR_AFTER_DEFAULT_PERIOD = 15;
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<String> recipient = Optional.of("https://signin.service.gov.uk");
    private Optional<DateTime> notOnOrAfter = Optional.of(DateTime.now().plusMinutes(15));
    private Optional<DateTime> notBefore = Optional.empty();
    private Optional<String> address = Optional.empty();
    private Optional<String> inResponseTo = Optional.of("_default-request-id_min-20-chars");
    private List<Assertion> assertions = new ArrayList<Assertion>();
    private List<EncryptedAssertion> encryptedAssertions = new ArrayList<EncryptedAssertion>();

    public static SubjectConfirmationDataBuilder aSubjectConfirmationData() {
        return new SubjectConfirmationDataBuilder();
    }

    public SubjectConfirmationData build() {
        SubjectConfirmationData subjectConfirmationData = this.openSamlXmlObjectFactory.createSubjectConfirmationData();
        if (this.recipient.isPresent()) {
            subjectConfirmationData.setRecipient(this.recipient.get());
        }
        if (this.notOnOrAfter.isPresent()) {
            subjectConfirmationData.setNotOnOrAfter(this.notOnOrAfter.get());
        }
        if (this.notBefore.isPresent()) {
            subjectConfirmationData.setNotBefore(this.notBefore.get());
        }
        if (this.inResponseTo.isPresent()) {
            subjectConfirmationData.setInResponseTo(this.inResponseTo.get());
        }
        if (this.address.isPresent()) {
            subjectConfirmationData.setAddress(this.address.get());
        }
        subjectConfirmationData.getUnknownXMLObjects().addAll(this.assertions);
        subjectConfirmationData.getUnknownXMLObjects().addAll(this.encryptedAssertions);
        return subjectConfirmationData;
    }

    public SubjectConfirmationDataBuilder withRecipient(String recipient) {
        this.recipient = Optional.ofNullable(recipient);
        return this;
    }

    public SubjectConfirmationDataBuilder withNotOnOrAfter(DateTime notOnOrAfter) {
        this.notOnOrAfter = Optional.ofNullable(notOnOrAfter);
        return this;
    }

    public SubjectConfirmationDataBuilder withNotBefore(DateTime notBefore) {
        this.notBefore = Optional.ofNullable(notBefore);
        return this;
    }

    public SubjectConfirmationDataBuilder withAddress(String address) {
        this.address = Optional.ofNullable(address);
        return this;
    }

    public SubjectConfirmationDataBuilder withInResponseTo(String inResponseTo) {
        this.inResponseTo = Optional.ofNullable(inResponseTo);
        return this;
    }

    public SubjectConfirmationDataBuilder addAssertion(Assertion assertion) {
        this.assertions.add(assertion);
        return this;
    }

    public SubjectConfirmationDataBuilder addAssertions(List<Assertion> assertions) {
        this.assertions.addAll(assertions);
        return this;
    }

    public SubjectConfirmationDataBuilder addAssertion(EncryptedAssertion assertion) {
        this.encryptedAssertions.add(assertion);
        return this;
    }

    public SubjectConfirmationDataBuilder addEncryptedAssertions(List<EncryptedAssertion> assertions) {
        this.encryptedAssertions.addAll(assertions);
        return this;
    }
}

