/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.Optional;
import org.opensaml.saml.saml2.core.StatusCode;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;

public class StatusCodeBuilder {
    private static OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<String> value = Optional.of("urn:oasis:names:tc:SAML:2.0:status:Success");
    private Optional<StatusCode> subStatus = Optional.empty();

    public static StatusCodeBuilder aStatusCode() {
        return new StatusCodeBuilder();
    }

    public StatusCode build() {
        StatusCode statusCode = openSamlXmlObjectFactory.createStatusCode();
        if (this.value.isPresent()) {
            statusCode.setValue(this.value.get());
        }
        if (this.subStatus.isPresent()) {
            statusCode.setStatusCode(this.subStatus.get());
        }
        return statusCode;
    }

    public StatusCodeBuilder withValue(String value) {
        this.value = Optional.ofNullable(value);
        return this;
    }

    public StatusCodeBuilder withSubStatusCode(StatusCode subStatusCode) {
        this.subStatus = Optional.ofNullable(subStatusCode);
        return this;
    }

    public StatusCodeBuilder forMatchingService() {
        this.withSubStatusCode(StatusCodeBuilder.aStatusCode().withValue("urn:uk:gov:cabinet-office:tc:saml:statuscode:match").build());
        return this;
    }
}

