/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.Optional;
import org.opensaml.saml.saml2.core.Attribute;
import uk.gov.ida.saml.core.extensions.StringBasedMdsAttributeValue;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;

public class SimpleStringAttributeBuilder {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<String> name = Optional.empty();
    private Optional<String> simpleStringValue = Optional.empty();

    public static SimpleStringAttributeBuilder aSimpleStringAttribute() {
        return new SimpleStringAttributeBuilder();
    }

    public Attribute build() {
        Attribute attribute = this.openSamlXmlObjectFactory.createAttribute();
        if (this.name.isPresent()) {
            attribute.setName(this.name.get());
        }
        if (this.simpleStringValue.isPresent()) {
            StringBasedMdsAttributeValue attributeValue = this.openSamlXmlObjectFactory.createSimpleMdsAttributeValue(this.simpleStringValue.get());
            attribute.getAttributeValues().add(attributeValue);
        }
        return attribute;
    }

    public SimpleStringAttributeBuilder withName(String name) {
        this.name = Optional.ofNullable(name);
        return this;
    }

    public SimpleStringAttributeBuilder withSimpleStringValue(String value) {
        this.simpleStringValue = Optional.ofNullable(value);
        return this;
    }
}

