/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.opensaml.xmlsec.signature.Signature;
import uk.gov.ida.saml.core.domain.IdpIdaStatus;
import uk.gov.ida.saml.core.domain.InboundResponseFromIdp;
import uk.gov.ida.saml.core.domain.OutboundResponseFromHub;
import uk.gov.ida.saml.core.domain.PassthroughAssertion;
import uk.gov.ida.saml.core.domain.TransactionIdaStatus;

public class ResponseForHubBuilder {
    private String responseId = "response-id";
    private String inResponseTo = "request-id";
    private String issuerId = "issuer-id";
    private DateTime issueInstant = DateTime.now();
    private TransactionIdaStatus transactionIdpStatus = TransactionIdaStatus.Success;
    private IdpIdaStatus idpIdaStatus = IdpIdaStatus.success();
    private Optional<Signature> signature = null;
    private Optional<PassthroughAssertion> authnStatementAssertion = Optional.empty();
    private Optional<PassthroughAssertion> matchingDatasetAssertion = Optional.empty();
    private List<String> encryptedAssertions = Collections.emptyList();

    public static ResponseForHubBuilder anAuthnResponse() {
        return new ResponseForHubBuilder();
    }

    public InboundResponseFromIdp buildInboundFromIdp() {
        return new InboundResponseFromIdp(this.responseId, this.inResponseTo, this.issuerId, this.issueInstant, this.idpIdaStatus, this.signature, this.matchingDatasetAssertion, null, this.authnStatementAssertion);
    }

    public InboundResponseFromIdp buildSuccessFromIdp() {
        return new InboundResponseFromIdp(this.responseId, this.inResponseTo, this.issuerId, this.issueInstant, this.idpIdaStatus, this.signature, this.matchingDatasetAssertion, null, this.authnStatementAssertion);
    }

    public OutboundResponseFromHub buildOutboundResponseFromHub() {
        return new OutboundResponseFromHub(this.responseId, this.inResponseTo, "https://signin.service.gov.uk", this.issueInstant, this.transactionIdpStatus, this.encryptedAssertions, URI.create("blah"));
    }

    public ResponseForHubBuilder withResponseId(String responseId) {
        this.responseId = responseId;
        return this;
    }

    public ResponseForHubBuilder withInResponseTo(String inResponseTo) {
        this.inResponseTo = inResponseTo;
        return this;
    }

    public ResponseForHubBuilder withIssuerId(String issuerId) {
        this.issuerId = issuerId;
        return this;
    }

    public ResponseForHubBuilder withIssueInstant(DateTime issueInstant) {
        this.issueInstant = issueInstant;
        return this;
    }

    public ResponseForHubBuilder withIdpIdaStatus(IdpIdaStatus status) {
        this.idpIdaStatus = status;
        return this;
    }

    public ResponseForHubBuilder withTransactionIdaStatus(TransactionIdaStatus status) {
        this.transactionIdpStatus = status;
        return this;
    }

    public ResponseForHubBuilder withSignature(Signature signature) {
        this.signature = Optional.ofNullable(signature);
        return this;
    }

    public ResponseForHubBuilder withAuthnStatementAssertion(PassthroughAssertion authnStatementAssertion) {
        this.authnStatementAssertion = Optional.ofNullable(authnStatementAssertion);
        return this;
    }

    public ResponseForHubBuilder withMatchingDatasetAssertion(PassthroughAssertion matchingDatasetAssertion) {
        this.matchingDatasetAssertion = Optional.ofNullable(matchingDatasetAssertion);
        return this;
    }

    public ResponseForHubBuilder withEncryptedAssertions(List<String> encryptedAssertions) {
        this.encryptedAssertions = encryptedAssertions;
        return this;
    }
}

