/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.Optional;
import org.opensaml.saml.saml2.core.NameID;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;

public class NameIdBuilder {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private String value = "default-pid";
    private Optional<String> format = Optional.of("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
    private Optional<String> nameQualifier = Optional.empty();
    private Optional<String> spNameQualifier = Optional.empty();

    public static NameIdBuilder aNameId() {
        return new NameIdBuilder();
    }

    public NameID build() {
        NameID nameId = this.openSamlXmlObjectFactory.createNameId(this.value);
        nameId.setFormat(null);
        if (this.format.isPresent()) {
            nameId.setFormat(this.format.get());
        }
        if (this.nameQualifier.isPresent()) {
            nameId.setNameQualifier(this.nameQualifier.get());
        }
        if (this.spNameQualifier.isPresent()) {
            nameId.setSPNameQualifier(this.spNameQualifier.get());
        }
        return nameId;
    }

    public NameIdBuilder withValue(String value) {
        this.value = value;
        return this;
    }

    public NameIdBuilder withFormat(String format) {
        this.format = Optional.ofNullable(format);
        return this;
    }

    public NameIdBuilder withNameQualifier(String nameQualifier) {
        this.nameQualifier = Optional.ofNullable(nameQualifier);
        return this;
    }

    public NameIdBuilder withSpNameQualifier(String spNameQualifier) {
        this.spNameQualifier = Optional.ofNullable(spNameQualifier);
        return this;
    }
}

