/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.Optional;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.Attribute;
import uk.gov.ida.saml.core.extensions.Gender;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;

public class GenderAttributeBuilder_1_1 {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<DateTime> from = Optional.empty();
    private Optional<DateTime> to = Optional.empty();
    private Optional<String> value = Optional.empty();
    private boolean verified = false;

    public static GenderAttributeBuilder_1_1 aGender_1_1() {
        return new GenderAttributeBuilder_1_1();
    }

    public Attribute build() {
        Attribute genderAttribute = this.openSamlXmlObjectFactory.createAttribute();
        genderAttribute.setFriendlyName("Gender");
        genderAttribute.setName("MDS_gender");
        genderAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
        return this.buildAttribute(genderAttribute);
    }

    public Attribute buildEidasGender() {
        Attribute genderAttribute = this.openSamlXmlObjectFactory.createAttribute();
        genderAttribute.setFriendlyName("Gender");
        genderAttribute.setName("http://eidas.europa.eu/attributes/naturalperson/Gender");
        genderAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
        return this.buildAttribute(genderAttribute);
    }

    private Attribute buildAttribute(Attribute genderAttribute) {
        Gender genderAttributeValue = this.openSamlXmlObjectFactory.createGenderAttributeValue(this.value.orElse("Male"));
        this.from.ifPresent(arg_0 -> ((Gender)genderAttributeValue).setFrom(arg_0));
        this.to.ifPresent(arg_0 -> ((Gender)genderAttributeValue).setTo(arg_0));
        genderAttributeValue.setVerified(this.verified);
        genderAttribute.getAttributeValues().add(genderAttributeValue);
        return genderAttribute;
    }

    public GenderAttributeBuilder_1_1 withFrom(DateTime from) {
        this.from = Optional.ofNullable(from);
        return this;
    }

    public GenderAttributeBuilder_1_1 withTo(DateTime to) {
        this.to = Optional.ofNullable(to);
        return this;
    }

    public GenderAttributeBuilder_1_1 withValue(String name) {
        this.value = Optional.ofNullable(name);
        return this;
    }

    public GenderAttributeBuilder_1_1 withVerified(boolean verified) {
        this.verified = verified;
        return this;
    }
}

