/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Conditions;
import uk.gov.ida.saml.core.test.builders.AudienceRestrictionBuilder;

public class ConditionsBuilder {
    private XMLObjectBuilderFactory xmlObjectBuilderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
    private List<AudienceRestriction> audienceRestrictions = new ArrayList<AudienceRestriction>();
    private AudienceRestriction defaultAudienceRestriction = AudienceRestrictionBuilder.anAudienceRestriction().build();
    private boolean shouldIncludeDefaultAudienceRestriction = true;
    private DateTime notBefore = null;
    private DateTime notOnOrAfter = null;

    public static ConditionsBuilder aConditions() {
        return new ConditionsBuilder();
    }

    public Conditions build() {
        Conditions conditions = (Conditions)this.xmlObjectBuilderFactory.getBuilder(Conditions.DEFAULT_ELEMENT_NAME).buildObject(Conditions.DEFAULT_ELEMENT_NAME, Conditions.TYPE_NAME);
        if (this.shouldIncludeDefaultAudienceRestriction) {
            this.audienceRestrictions.add(this.defaultAudienceRestriction);
        }
        conditions.getAudienceRestrictions().addAll(this.audienceRestrictions);
        conditions.setNotBefore(this.notBefore);
        conditions.setNotOnOrAfter(this.notOnOrAfter);
        return conditions;
    }

    public ConditionsBuilder withoutDefaultAudienceRestriction() {
        this.shouldIncludeDefaultAudienceRestriction = false;
        return this;
    }

    public ConditionsBuilder addAudienceRestriction(AudienceRestriction audienceRestriction) {
        this.shouldIncludeDefaultAudienceRestriction = false;
        this.audienceRestrictions.add(audienceRestriction);
        return this;
    }

    public ConditionsBuilder withNotBefore(DateTime notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public ConditionsBuilder withNotOnOrAfter(DateTime notOnOrAfter) {
        this.notOnOrAfter = notOnOrAfter;
        return this;
    }

    public ConditionsBuilder validFor(Duration duration) {
        return this.withNotBefore(DateTime.now()).withNotOnOrAfter(DateTime.now().plus((ReadableDuration)duration));
    }

    public ConditionsBuilder restrictedToAudience(String audienceUri) {
        AudienceRestriction audienceRestriction = AudienceRestrictionBuilder.anAudienceRestriction().withAudienceId(audienceUri).build();
        return this.addAudienceRestriction(audienceRestriction);
    }
}

