/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.algorithm.DigestAlgorithm;
import org.opensaml.xmlsec.algorithm.SignatureAlgorithm;
import org.opensaml.xmlsec.algorithm.descriptors.DigestSHA256;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA256;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import uk.gov.ida.saml.core.test.AuthnRequestIdGenerator;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.test.builders.IssuerBuilder;
import uk.gov.ida.saml.core.test.builders.SignatureBuilder;

public class AuthnRequestBuilder {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private boolean shouldSign = true;
    private boolean shouldAddSignature = true;
    private SignatureAlgorithm signatureAlgorithm = new SignatureRSASHA256();
    private DigestAlgorithm digestAlgorithm = new DigestSHA256();
    private Optional<NameIDPolicy> nameIdPolicy = Optional.empty();
    private Optional<Scoping> scoping = Optional.empty();
    private Optional<String> assertionConsumerServiceUrl = Optional.empty();
    private Optional<String> protocolBinding = Optional.ofNullable("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
    private Optional<Boolean> isPassive = Optional.empty();
    private Optional<Issuer> issuer = Optional.ofNullable(IssuerBuilder.anIssuer().build());
    private Optional<String> id = Optional.ofNullable(AuthnRequestIdGenerator.generateRequestId());
    private Optional<String> minimumLevelOfAssurance = Optional.ofNullable("urn:uk:gov:cabinet-office:tc:saml:authn-context:level1");
    private Optional<DateTime> issueInstant = Optional.ofNullable(DateTime.now());
    private Optional<String> versionNumber = Optional.ofNullable("2.0");
    private Optional<String> destination = Optional.empty();
    private Optional<String> requiredLevelOfAssurance = Optional.ofNullable("urn:uk:gov:cabinet-office:tc:saml:authn-context:level2");
    private Optional<Credential> signingCredential = Optional.empty();
    private Optional<Boolean> forceAuthn = Optional.empty();
    private Optional<Integer> assertionConsumerServiceIndex = Optional.empty();

    public static AuthnRequestBuilder anAuthnRequest() {
        return new AuthnRequestBuilder();
    }

    public AuthnRequest build() {
        AuthnRequest authnRequest = this.openSamlXmlObjectFactory.createAuthnRequest();
        if (this.issuer.isPresent()) {
            authnRequest.setIssuer(this.issuer.get());
        }
        if (this.id.isPresent()) {
            authnRequest.setID(this.id.get());
        }
        if (this.versionNumber.isPresent()) {
            authnRequest.setVersion(this.openSamlXmlObjectFactory.createSamlVersion(this.versionNumber.get()));
        } else {
            authnRequest.setVersion(null);
        }
        if (this.minimumLevelOfAssurance.isPresent() || this.requiredLevelOfAssurance.isPresent()) {
            AuthnContextClassRef authnContextClassReference;
            RequestedAuthnContext requestedAuthnContext = this.openSamlXmlObjectFactory.createRequestedAuthnContext(AuthnContextComparisonTypeEnumeration.MINIMUM);
            authnRequest.setRequestedAuthnContext(requestedAuthnContext);
            if (this.minimumLevelOfAssurance.isPresent()) {
                authnContextClassReference = this.openSamlXmlObjectFactory.createAuthnContextClassReference(this.minimumLevelOfAssurance.get());
                requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassReference);
            }
            if (this.requiredLevelOfAssurance.isPresent()) {
                authnContextClassReference = this.openSamlXmlObjectFactory.createAuthnContextClassReference(this.requiredLevelOfAssurance.get());
                requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassReference);
            }
        }
        if (this.nameIdPolicy.isPresent()) {
            authnRequest.setNameIDPolicy(this.nameIdPolicy.get());
        }
        if (this.scoping.isPresent()) {
            authnRequest.setScoping(this.scoping.get());
        }
        if (this.assertionConsumerServiceUrl.isPresent()) {
            authnRequest.setAssertionConsumerServiceURL(this.assertionConsumerServiceUrl.get());
        }
        if (this.protocolBinding.isPresent()) {
            authnRequest.setProtocolBinding(this.protocolBinding.get());
        }
        if (this.isPassive.isPresent()) {
            authnRequest.setIsPassive(this.isPassive.get());
        }
        if (this.issueInstant.isPresent()) {
            authnRequest.setIssueInstant(this.issueInstant.get());
        }
        if (this.destination.isPresent()) {
            authnRequest.setDestination(this.destination.get());
        }
        if (this.forceAuthn.isPresent()) {
            authnRequest.setForceAuthn(this.forceAuthn.get());
        }
        if (this.assertionConsumerServiceIndex.isPresent()) {
            authnRequest.setAssertionConsumerServiceIndex(this.assertionConsumerServiceIndex.get());
        }
        if (this.issuer.isPresent() && !Strings.isNullOrEmpty((String)this.issuer.get().getValue()) && this.shouldAddSignature) {
            SignatureBuilder signatureBuilder = SignatureBuilder.aSignature().withSignatureAlgorithm(this.signatureAlgorithm);
            if (this.id.isPresent()) {
                signatureBuilder.withDigestAlgorithm(this.id.get(), this.digestAlgorithm);
            }
            if (this.signingCredential.isPresent()) {
                signatureBuilder.withSigningCredential(this.signingCredential.get());
            }
            authnRequest.setSignature(signatureBuilder.build());
            try {
                XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)authnRequest).marshall((XMLObject)authnRequest);
                if (this.shouldSign) {
                    Signer.signObject((Signature)authnRequest.getSignature());
                }
            }
            catch (MarshallingException | SignatureException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return authnRequest;
    }

    public AuthnRequestBuilder withoutSignatureElement() {
        this.shouldAddSignature = false;
        return this;
    }

    public AuthnRequestBuilder withoutSigning() {
        this.shouldSign = false;
        return this;
    }

    public AuthnRequestBuilder withId(String id) {
        this.id = Optional.ofNullable(id);
        return this;
    }

    public AuthnRequestBuilder withIssuer(Issuer issuer) {
        this.issuer = Optional.ofNullable(issuer);
        return this;
    }

    public AuthnRequestBuilder withNameIdPolicy(NameIDPolicy policy) {
        this.nameIdPolicy = Optional.ofNullable(policy);
        return this;
    }

    public AuthnRequestBuilder withScoping(Scoping scoping) {
        this.scoping = Optional.ofNullable(scoping);
        return this;
    }

    public AuthnRequestBuilder withAssertionConsumerServiceUrl(String url) {
        this.assertionConsumerServiceUrl = Optional.ofNullable(url);
        return this;
    }

    public AuthnRequestBuilder withProtocolBinding(String protocolBinding) {
        this.protocolBinding = Optional.ofNullable(protocolBinding);
        return this;
    }

    public AuthnRequestBuilder withIsPassive(boolean isPassive) {
        this.isPassive = Optional.ofNullable(isPassive);
        return this;
    }

    public AuthnRequestBuilder withIssueInstant(DateTime dateTime) {
        this.issueInstant = Optional.ofNullable(dateTime);
        return this;
    }

    public AuthnRequestBuilder withVersionNumber(String versionNumber) {
        this.versionNumber = Optional.ofNullable(versionNumber);
        return this;
    }

    public AuthnRequestBuilder withDestination(String destination) {
        this.destination = Optional.ofNullable(destination);
        return this;
    }

    public AuthnRequestBuilder withSigningCredential(Credential credential) {
        this.signingCredential = Optional.ofNullable(credential);
        this.shouldAddSignature = true;
        return this;
    }

    public AuthnRequestBuilder withForceAuthn(Boolean forceAuthn) {
        this.forceAuthn = Optional.of(forceAuthn);
        return this;
    }

    public AuthnRequestBuilder withSignatureAlgorithm(@NotNull SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public AuthnRequestBuilder withDigestAlgorithm(@NotNull DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }

    public void withAssertionConsumerServiceIndex(Integer index) {
        this.assertionConsumerServiceIndex = Optional.of(index);
    }
}

