/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import uk.gov.ida.saml.core.test.TestCertificateStrings;
import uk.gov.ida.saml.core.test.TestCredentialFactory;
import uk.gov.ida.saml.core.test.builders.AttributeStatementBuilder;
import uk.gov.ida.saml.core.test.builders.AuthnStatementBuilder;
import uk.gov.ida.saml.core.test.builders.ConditionsBuilder;
import uk.gov.ida.saml.core.test.builders.IPAddressAttributeBuilder;
import uk.gov.ida.saml.core.test.builders.IssuerBuilder;
import uk.gov.ida.saml.core.test.builders.SignatureBuilder;
import uk.gov.ida.saml.core.test.builders.SimpleStringAttributeBuilder;
import uk.gov.ida.saml.core.test.builders.SubjectBuilder;

public class AssertionBuilder {
    private static XMLObjectBuilderFactory factory = XMLObjectProviderRegistrySupport.getBuilderFactory();
    private boolean shouldSign = true;
    private SAMLVersion version = SAMLVersion.VERSION_20;
    private List<AttributeStatement> attributeStatements = new ArrayList<AttributeStatement>();
    private List<AuthnStatement> authnStatements = new ArrayList<AuthnStatement>();
    private Optional<String> id = Optional.of("some-assertion-id");
    private Optional<Subject> subject = Optional.ofNullable(SubjectBuilder.aSubject().build());
    private Optional<Issuer> issuer = Optional.ofNullable(IssuerBuilder.anIssuer().build());
    private Optional<Signature> signature = Optional.ofNullable(SignatureBuilder.aSignature().build());
    private Optional<Conditions> conditions = Optional.ofNullable(ConditionsBuilder.aConditions().build());
    private Optional<DateTime> issueInstant = Optional.of(DateTime.now());

    public static AssertionBuilder anAssertion() {
        return new AssertionBuilder();
    }

    public static AssertionBuilder anAuthnStatementAssertion() {
        return AssertionBuilder.anAssertion().addAuthnStatement(AuthnStatementBuilder.anAuthnStatement().build()).addAttributeStatement(AttributeStatementBuilder.anAttributeStatement().addAttribute(IPAddressAttributeBuilder.anIPAddress().build()).build());
    }

    public static AssertionBuilder aMatchingDatasetAssertion(Attribute firstName, Attribute middlenames, Attribute surname, Attribute gender, Attribute dateOfBirth, Attribute currentAddress, Attribute previousAddresses) {
        AttributeStatementBuilder attributeStatementBuilder = AttributeStatementBuilder.anAttributeStatement().addAttribute(firstName).addAttribute(middlenames).addAttribute(surname).addAttribute(gender).addAttribute(dateOfBirth).addAttribute(currentAddress).addAttribute(previousAddresses);
        return AssertionBuilder.anAssertion().addAttributeStatement(attributeStatementBuilder.build());
    }

    public static AssertionBuilder anEidasMatchingDatasetAssertion(Attribute firstName, Attribute surname, Attribute dateOfBirth, Attribute personalIdentifier) {
        return AssertionBuilder.anEidasMatchingDatasetAssertion(firstName, surname, dateOfBirth, personalIdentifier, Optional.empty());
    }

    public static AssertionBuilder anEidasMatchingDatasetAssertion(Attribute firstName, Attribute surname, Attribute dateOfBirth, Attribute personalIdentifier, Optional<Attribute> gender) {
        AttributeStatementBuilder attributeStatementBuilder = AttributeStatementBuilder.anAttributeStatement().addAttribute(firstName).addAttribute(surname).addAttribute(dateOfBirth).addAttribute(personalIdentifier);
        gender.ifPresent(attributeStatementBuilder::addAttribute);
        return AssertionBuilder.anAssertion().addAttributeStatement(attributeStatementBuilder.build());
    }

    public static AssertionBuilder aCycle3DatasetAssertion(String name, String value) {
        SimpleStringAttributeBuilder attribute = SimpleStringAttributeBuilder.aSimpleStringAttribute().withName(name).withSimpleStringValue(value);
        AttributeStatementBuilder attributeStatementBuilder = AttributeStatementBuilder.anAttributeStatement().addAttribute(attribute.build());
        return AssertionBuilder.anAssertion().withIssuer(IssuerBuilder.anIssuer().withIssuerId("https://signin.service.gov.uk").build()).addAttributeStatement(attributeStatementBuilder.build());
    }

    public static AssertionBuilder aCycle3DatasetAssertion(List<Attribute> attributes) {
        AttributeStatementBuilder attributeStatementBuilder = AttributeStatementBuilder.anAttributeStatement();
        for (Attribute attribute : attributes) {
            attributeStatementBuilder.addAttribute(attribute);
        }
        return AssertionBuilder.anAssertion().withIssuer(IssuerBuilder.anIssuer().withIssuerId("https://signin.service.gov.uk").build()).addAttributeStatement(attributeStatementBuilder.build());
    }

    public Assertion buildUnencrypted() {
        Assertion assertion = (Assertion)factory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME).buildObject(Assertion.DEFAULT_ELEMENT_NAME, Assertion.TYPE_NAME);
        if (this.id.isPresent()) {
            assertion.setID(this.id.get());
        }
        assertion.setVersion(this.version);
        if (this.subject.isPresent()) {
            assertion.setSubject(this.subject.get());
        }
        if (this.issueInstant.isPresent()) {
            assertion.setIssueInstant(this.issueInstant.get());
        }
        assertion.getAttributeStatements().addAll(this.attributeStatements);
        assertion.getAuthnStatements().addAll(this.authnStatements);
        if (this.issuer.isPresent()) {
            assertion.setIssuer(this.issuer.get());
        }
        if (this.conditions.isPresent()) {
            assertion.setConditions(this.conditions.get());
        }
        try {
            if (this.signature.isPresent()) {
                assertion.setSignature(this.signature.get());
                XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)assertion).marshall((XMLObject)assertion);
                if (this.shouldSign) {
                    Signer.signObject((Signature)assertion.getSignature());
                }
            }
        }
        catch (MarshallingException | SignatureException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return assertion;
    }

    public EncryptedAssertion build() {
        TestCredentialFactory credentialFactory = new TestCredentialFactory(TestCertificateStrings.TEST_PUBLIC_CERT, null);
        Credential credential = credentialFactory.getEncryptingCredential();
        return this.buildWithEncrypterCredential(credential);
    }

    public EncryptedAssertion buildWithEncrypterCredential(Credential credential) {
        return this.buildWithEncrypterCredential(this.createEncrypter(credential));
    }

    public EncryptedAssertion buildWithEncrypterCredential(Credential credential, String encryptionAlgorithm) {
        return this.buildWithEncrypterCredential(this.createEncrypter(credential, encryptionAlgorithm));
    }

    public EncryptedAssertion buildWithEncrypterCredential(Credential credential, String encryptionAlgorithm, String keyTransportEncryptionAlgorithm) {
        return this.buildWithEncrypterCredential(this.createEncrypter(credential, encryptionAlgorithm, keyTransportEncryptionAlgorithm));
    }

    public Encrypter createEncrypter(Credential credential) {
        return this.createEncrypter(credential, "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
    }

    public Encrypter createEncrypter(Credential credential, String encryptionAlgorithm) {
        return this.createEncrypter(credential, encryptionAlgorithm, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
    }

    public Encrypter createEncrypter(Credential credential, String encryptionAlgorithm, String keyTransportEncryptionAlgorithm) {
        DataEncryptionParameters encParams = new DataEncryptionParameters();
        encParams.setAlgorithm(encryptionAlgorithm);
        KeyEncryptionParameters kekParams = new KeyEncryptionParameters();
        kekParams.setEncryptionCredential(credential);
        kekParams.setAlgorithm(keyTransportEncryptionAlgorithm);
        Encrypter encrypter = new Encrypter(encParams, kekParams);
        encrypter.setKeyPlacement(Encrypter.KeyPlacement.PEER);
        return encrypter;
    }

    public EncryptedAssertion buildWithEncrypterCredential(Encrypter encrypter) {
        Assertion assertion = this.buildUnencrypted();
        try {
            return encrypter.encrypt(assertion);
        }
        catch (EncryptionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public AssertionBuilder withId(String id) {
        this.id = Optional.ofNullable(id);
        return this;
    }

    public AssertionBuilder withSubject(Subject subject) {
        this.subject = Optional.ofNullable(subject);
        return this;
    }

    public AssertionBuilder withIssuer(Issuer issuer) {
        this.issuer = Optional.ofNullable(issuer);
        return this;
    }

    public AssertionBuilder addAttributeStatement(AttributeStatement attributeStatement) {
        this.attributeStatements.add(attributeStatement);
        return this;
    }

    public AssertionBuilder withoutAttributeStatements() {
        this.attributeStatements.clear();
        return this;
    }

    public AssertionBuilder addAuthnStatement(AuthnStatement authnStatement) {
        this.authnStatements.add(authnStatement);
        return this;
    }

    public AssertionBuilder withoutAuthnStatements() {
        this.authnStatements.clear();
        return this;
    }

    public AssertionBuilder withoutSigning() {
        this.shouldSign = false;
        return this;
    }

    public AssertionBuilder withSignature(Signature signature) {
        this.signature = Optional.ofNullable(signature);
        return this;
    }

    public AssertionBuilder withIssueInstant(DateTime issueInstant) {
        this.issueInstant = Optional.ofNullable(issueInstant);
        return this;
    }

    public AssertionBuilder withVersion(SAMLVersion version) {
        this.version = version;
        return this;
    }

    public AssertionBuilder withConditions(Conditions conditions) {
        this.conditions = Optional.ofNullable(conditions);
        return this;
    }
}

