/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import uk.gov.ida.saml.core.domain.Address;

public class AddressBuilder {
    private List<String> lines = new ArrayList<String>();
    private Optional<String> postCode = Optional.empty();
    private Optional<String> internationalPostCode = Optional.empty();
    private Optional<String> uprn = Optional.empty();
    private DateTime fromDate = DateTime.parse((String)"2001-01-01");
    private Optional<DateTime> toDate = Optional.empty();
    private boolean verified = false;

    public static AddressBuilder anAddress() {
        return new AddressBuilder();
    }

    public Address build() {
        return new Address(this.lines, this.postCode, this.internationalPostCode, this.uprn, this.fromDate, this.toDate, this.verified);
    }

    public AddressBuilder withLines(List<String> lines) {
        this.lines = lines;
        return this;
    }

    public AddressBuilder withPostCode(String postCode) {
        this.postCode = Optional.ofNullable(postCode);
        return this;
    }

    public AddressBuilder withInternationalPostCode(String internationalPostCode) {
        this.internationalPostCode = Optional.ofNullable(internationalPostCode);
        return this;
    }

    public AddressBuilder withUPRN(String uprn) {
        this.uprn = Optional.ofNullable(uprn);
        return this;
    }

    public AddressBuilder withFromDate(DateTime fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    public AddressBuilder withToDate(DateTime toDate) {
        this.toDate = Optional.ofNullable(toDate);
        return this;
    }

    public AddressBuilder withVerified(boolean verified) {
        this.verified = verified;
        return this;
    }
}

