/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.MessageFormat;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;

public class TestCredentialFactory {
    private final String publicCert;
    private final String privateCert;

    @Inject
    public TestCredentialFactory(String publicCert, String privateKey) {
        this.publicCert = publicCert;
        this.privateCert = privateKey;
    }

    public Credential getSigningCredential() {
        BasicCredential credential = new BasicCredential(this.getPublicKey(), this.getPrivateKey());
        credential.setUsageType(UsageType.SIGNING);
        return credential;
    }

    public Credential getEncryptingCredential() {
        BasicCredential credential = new BasicCredential(this.getPublicKey());
        credential.setUsageType(UsageType.ENCRYPTION);
        return credential;
    }

    public Credential getDecryptingCredential() {
        BasicCredential credential = new BasicCredential(this.getPublicKey(), this.getPrivateKey());
        credential.setUsageType(UsageType.ENCRYPTION);
        return credential;
    }

    private PublicKey getPublicKey() {
        try {
            return this.createPublicKey(this.publicCert);
        }
        catch (UnsupportedEncodingException | CertificateException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private PrivateKey getPrivateKey() {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)this.privateCert));
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private PublicKey createPublicKey(String partialCert) throws CertificateException, UnsupportedEncodingException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        String fullCert = partialCert.contains("-----BEGIN CERTIFICATE-----") ? partialCert : MessageFormat.format("-----BEGIN CERTIFICATE-----\n{0}\n-----END CERTIFICATE-----", partialCert.trim());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fullCert.getBytes("UTF-8"));
        Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
        return certificate.getPublicKey();
    }
}

