/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata.test.factories.metadata;

import com.google.common.base.Throwables;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import uk.gov.ida.saml.core.test.TestCertificateStrings;
import uk.gov.ida.saml.core.test.builders.metadata.EntitiesDescriptorBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.SignatureBuilder;
import uk.gov.ida.saml.metadata.test.factories.metadata.EntityDescriptorFactory;
import uk.gov.ida.saml.metadata.test.factories.metadata.TestCredentialFactory;

public class EntitiesDescriptorFactory {
    private final DateTime validUntil = DateTime.now().plusWeeks(2);
    private EntityDescriptorFactory entityDescriptorFactory = new EntityDescriptorFactory();

    public EntitiesDescriptor defaultEntitiesDescriptor() {
        return this.entitiesDescriptor(this.defaultEntityDescriptors());
    }

    public EntitiesDescriptor emptyEntitiesDescriptor() {
        return this.entitiesDescriptor(Collections.emptyList());
    }

    public EntitiesDescriptor entitiesDescriptor(List<EntityDescriptor> entityDescriptors) {
        return this.buildEntitiesDescriptor(entityDescriptors, Optional.of(this.defaultSignature()), this.validUntil);
    }

    public EntitiesDescriptor expiredEntitiesDescriptor() {
        DateTime expired = DateTime.now().minusWeeks(2);
        return this.buildEntitiesDescriptor(this.defaultEntityDescriptors(), Optional.of(this.defaultSignature()), expired);
    }

    public EntitiesDescriptor unsignedEntitiesDescriptor() {
        return this.buildEntitiesDescriptor(this.defaultEntityDescriptors(), Optional.empty(), this.validUntil);
    }

    private EntitiesDescriptor buildEntitiesDescriptor(List<EntityDescriptor> entityDescriptors, Optional<Signature> signature, DateTime validUntil) {
        EntitiesDescriptorBuilder entitiesDescriptorBuilder = this.entitiesDescriptorBuilder(entityDescriptors, signature, validUntil);
        return this.buildEntitiesDescriptor(entitiesDescriptorBuilder);
    }

    private EntitiesDescriptor buildEntitiesDescriptor(EntitiesDescriptorBuilder entitiesDescriptorBuilder) {
        try {
            return entitiesDescriptorBuilder.build();
        }
        catch (MarshallingException | SignatureException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private EntitiesDescriptorBuilder entitiesDescriptorBuilder(List<EntityDescriptor> entityDescriptors, Optional<Signature> signature, DateTime validUntil) {
        EntitiesDescriptorBuilder entitiesDescriptorBuilder = EntitiesDescriptorBuilder.anEntitiesDescriptor().withEntityDescriptors(entityDescriptors).withValidUntil(validUntil);
        signature.ifPresent(entitiesDescriptorBuilder::withSignature);
        return entitiesDescriptorBuilder;
    }

    private List<EntityDescriptor> defaultEntityDescriptors() {
        return this.entityDescriptorFactory.defaultEntityDescriptors();
    }

    private Signature defaultSignature() {
        return this.buildSignature(TestCertificateStrings.METADATA_SIGNING_A_PUBLIC_CERT, TestCertificateStrings.METADATA_SIGNING_A_PRIVATE_KEY);
    }

    private Signature buildSignature(String publicCertificate, String privateKey) {
        TestCredentialFactory testCredentialFactory = new TestCredentialFactory(publicCertificate, privateKey);
        Credential credential = testCredentialFactory.getSigningCredential();
        return SignatureBuilder.aSignature().withSigningCredential(credential).withX509Data(publicCertificate).build();
    }

    private Signature buildFullChainSignature(String publicCertificate, List<String> certificateChain, String privateKey) {
        TestCredentialFactory testCredentialFactory = new TestCredentialFactory(publicCertificate, privateKey);
        Credential credential = testCredentialFactory.getSigningCredential();
        return SignatureBuilder.aSignature().withSigningCredential(credential).withX509Data(certificateChain).build();
    }

    public EntitiesDescriptor signedEntitiesDescriptor(String publicCertificate, String privateKey) {
        return this.buildEntitiesDescriptor(this.defaultEntityDescriptors(), Optional.of(this.buildSignature(publicCertificate, privateKey)), this.validUntil);
    }

    public EntitiesDescriptor signedEntitiesDescriptor(Signature signature) {
        return this.buildEntitiesDescriptor(this.defaultEntityDescriptors(), Optional.of(signature), this.validUntil);
    }

    public EntitiesDescriptor signedEntitiesDescriptor(String id, Signature signature) {
        EntitiesDescriptorBuilder entitiesDescriptorBuilder = this.entitiesDescriptorBuilder(this.defaultEntityDescriptors(), Optional.of(signature), this.validUntil);
        entitiesDescriptorBuilder.withId(id);
        return this.buildEntitiesDescriptor(entitiesDescriptorBuilder);
    }

    public EntitiesDescriptor fullChainSignedEntitiesDescriptor(String publicCertificate, List<String> certificateChain, String privateKey) {
        return this.buildEntitiesDescriptor(this.defaultEntityDescriptors(), Optional.of(this.buildFullChainSignature(publicCertificate, certificateChain, privateKey)), this.validUntil);
    }
}

