/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders.metadata;

import java.util.ArrayList;
import java.util.List;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.UsageType;
import uk.gov.ida.saml.core.test.builders.metadata.AssertionConsumerServiceBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.KeyDescriptorBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.KeyInfoBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.X509CertificateBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.X509DataBuilder;

public class SPSSODescriptorBuilder {
    private List<String> supportedProtocols = new ArrayList<String>();
    private List<KeyDescriptor> keyDescriptors = new ArrayList<KeyDescriptor>();
    private boolean addDefaultSigningKey = true;
    private boolean addDefaultEncryptionKey = true;
    private KeyDescriptor defaultSigningKeyDescriptor = KeyDescriptorBuilder.aKeyDescriptor().withKeyInfo(KeyInfoBuilder.aKeyInfo().withKeyName("https://signin.service.gov.uk").withX509Data(X509DataBuilder.aX509Data().withX509Certificate(X509CertificateBuilder.aX509Certificate().build()).build()).build()).withUse(UsageType.SIGNING.toString()).build();
    private KeyDescriptor defaultEncryptionKeyDescriptor = KeyDescriptorBuilder.aKeyDescriptor().withKeyInfo(KeyInfoBuilder.aKeyInfo().withKeyName("https://signin.service.gov.uk").withX509Data(X509DataBuilder.aX509Data().withX509Certificate(X509CertificateBuilder.aX509Certificate().build()).build()).build()).withUse(UsageType.ENCRYPTION.toString()).build();
    private List<AssertionConsumerService> assertionConsumerServices = new ArrayList<AssertionConsumerService>();
    private AssertionConsumerService defaultAssertionConsumerService = AssertionConsumerServiceBuilder.anAssertionConsumerService().build();
    private boolean addDefaultAssertionConsumerService = true;
    private boolean addDefaultSupportedProtocol = true;
    private String defaultSupportedProtocol = "urn:oasis:names:tc:SAML:2.0:protocol";

    public static SPSSODescriptorBuilder anSpServiceDescriptor() {
        return new SPSSODescriptorBuilder();
    }

    public SPSSODescriptor build() {
        SPSSODescriptor descriptor = new org.opensaml.saml.saml2.metadata.impl.SPSSODescriptorBuilder().buildObject();
        if (this.addDefaultSupportedProtocol) {
            descriptor.addSupportedProtocol(this.defaultSupportedProtocol);
        }
        for (String protocol : this.supportedProtocols) {
            descriptor.addSupportedProtocol(protocol);
        }
        if (this.addDefaultAssertionConsumerService) {
            descriptor.getAssertionConsumerServices().add(this.defaultAssertionConsumerService);
        }
        for (AssertionConsumerService service : this.assertionConsumerServices) {
            descriptor.getAssertionConsumerServices().add(service);
        }
        if (this.addDefaultSigningKey) {
            descriptor.getKeyDescriptors().add(this.defaultSigningKeyDescriptor);
        }
        if (this.addDefaultEncryptionKey) {
            descriptor.getKeyDescriptors().add(this.defaultEncryptionKeyDescriptor);
        }
        for (KeyDescriptor keyDescriptor : this.keyDescriptors) {
            descriptor.getKeyDescriptors().add(keyDescriptor);
        }
        return descriptor;
    }

    public SPSSODescriptorBuilder addSupportedProtocol(String protocol) {
        this.supportedProtocols.add(protocol);
        this.addDefaultSupportedProtocol = false;
        return this;
    }

    public SPSSODescriptorBuilder withoutDefaultSupportingProtocol() {
        this.addDefaultSupportedProtocol = false;
        return this;
    }

    public SPSSODescriptorBuilder addKeyDescriptor(KeyDescriptor keyDescriptor) {
        this.keyDescriptors.add(keyDescriptor);
        return this;
    }

    public SPSSODescriptorBuilder withoutDefaultSigningKey() {
        this.addDefaultSigningKey = false;
        return this;
    }

    public SPSSODescriptorBuilder withoutDefaultEncryptionKey() {
        this.addDefaultEncryptionKey = false;
        return this;
    }

    public SPSSODescriptorBuilder addAssertionConsumerService(AssertionConsumerService service) {
        this.addDefaultAssertionConsumerService = false;
        this.assertionConsumerServices.add(service);
        return this;
    }

    public SPSSODescriptorBuilder withoutDefaultAssertionConsumerService() {
        this.addDefaultAssertionConsumerService = false;
        return this;
    }
}

