/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml.saml2.metadata.impl.IDPSSODescriptorBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.EndpointBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.KeyDescriptorBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.KeyInfoBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.X509CertificateBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.X509DataBuilder;

public class IdpSsoDescriptorBuilder {
    private Optional<String> protocol = Optional.of("urn:oasis:names:tc:SAML:2.0:protocol");
    private Optional<SingleSignOnService> singleSignOnService = Optional.ofNullable(EndpointBuilder.anEndpoint().buildSingleSignOnService());
    private List<KeyDescriptor> keyDescriptors = new ArrayList<KeyDescriptor>();
    private boolean addDefaultSigningKey = true;
    private KeyDescriptor defaultSigningKeyDescriptor = KeyDescriptorBuilder.aKeyDescriptor().withKeyInfo(KeyInfoBuilder.aKeyInfo().withKeyName("https://signin.service.gov.uk").withX509Data(X509DataBuilder.aX509Data().withX509Certificate(X509CertificateBuilder.aX509Certificate().build()).build()).build()).build();

    public static IdpSsoDescriptorBuilder anIdpSsoDescriptor() {
        return new IdpSsoDescriptorBuilder();
    }

    public IDPSSODescriptor build() {
        IDPSSODescriptor descriptor = new IDPSSODescriptorBuilder().buildObject();
        if (this.protocol.isPresent()) {
            descriptor.addSupportedProtocol(this.protocol.get());
        }
        if (this.singleSignOnService.isPresent()) {
            descriptor.getSingleSignOnServices().add(this.singleSignOnService.get());
        }
        if (this.addDefaultSigningKey) {
            descriptor.getKeyDescriptors().add(this.defaultSigningKeyDescriptor);
        }
        for (KeyDescriptor keyDescriptor : this.keyDescriptors) {
            descriptor.getKeyDescriptors().add(keyDescriptor);
        }
        return descriptor;
    }

    public IdpSsoDescriptorBuilder withSupportedProtocol(String protocol) {
        this.protocol = Optional.ofNullable(protocol);
        return this;
    }

    public IdpSsoDescriptorBuilder withSingleSignOnService(SingleSignOnService singleSignOnService) {
        this.singleSignOnService = Optional.ofNullable(singleSignOnService);
        return this;
    }

    public IdpSsoDescriptorBuilder addKeyDescriptor(KeyDescriptor keyDescriptor) {
        this.keyDescriptors.add(keyDescriptor);
        return this;
    }

    public IdpSsoDescriptorBuilder withoutDefaultSigningKey() {
        this.addDefaultSigningKey = false;
        return this;
    }
}

