/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import uk.gov.ida.saml.core.test.builders.metadata.ContactPersonBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.IdpSsoDescriptorBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.KeyDescriptorBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.OrganizationBuilder;
import uk.gov.ida.saml.core.test.builders.metadata.SPSSODescriptorBuilder;

public class EntityDescriptorBuilder {
    private String entityId = "https://signin.service.gov.uk";
    private boolean addDefaultSpServiceDescriptor = true;
    private boolean addDefaultContactPerson = true;
    private boolean shouldBeSigned = true;
    private Long cacheDuration = 100000L;
    private Organization organization = OrganizationBuilder.anOrganization().build();
    private List<SPSSODescriptor> spServiceDescriptors = new ArrayList<SPSSODescriptor>();
    private DateTime validUntil = DateTime.now().plusDays(1);
    private List<ContactPerson> contactPersons = new ArrayList<ContactPerson>();
    private String id = UUID.randomUUID().toString();
    private final SPSSODescriptor defaultSpServiceDescriptor = SPSSODescriptorBuilder.anSpServiceDescriptor().addKeyDescriptor(KeyDescriptorBuilder.aKeyDescriptor().withX509ForSigning("").build()).addKeyDescriptor(KeyDescriptorBuilder.aKeyDescriptor().withX509ForEncryption("").build()).build();
    private final ContactPerson defaultContactPerson = ContactPersonBuilder.aContactPerson().build();
    private Optional<IDPSSODescriptor> idpSsoDescriptor = Optional.ofNullable(IdpSsoDescriptorBuilder.anIdpSsoDescriptor().build());
    private Optional<Signature> signature = Optional.empty();
    private Optional<AttributeAuthorityDescriptor> attributeAuthorityDescriptor = Optional.empty();

    public static EntityDescriptorBuilder anEntityDescriptor() {
        return new EntityDescriptorBuilder();
    }

    public EntityDescriptor build() throws MarshallingException, SignatureException {
        EntityDescriptor entityDescriptor = new org.opensaml.saml.saml2.metadata.impl.EntityDescriptorBuilder().buildObject();
        entityDescriptor.setEntityID(this.entityId);
        entityDescriptor.setOrganization(this.organization);
        if (this.idpSsoDescriptor.isPresent()) {
            entityDescriptor.getRoleDescriptors().add((RoleDescriptor)this.idpSsoDescriptor.get());
        }
        if (this.attributeAuthorityDescriptor.isPresent()) {
            entityDescriptor.getRoleDescriptors().add((RoleDescriptor)this.attributeAuthorityDescriptor.get());
        }
        if (this.addDefaultSpServiceDescriptor) {
            entityDescriptor.getRoleDescriptors().add(this.defaultSpServiceDescriptor);
        }
        entityDescriptor.getRoleDescriptors().addAll(this.spServiceDescriptors);
        entityDescriptor.setValidUntil(this.validUntil);
        entityDescriptor.setCacheDuration(this.cacheDuration);
        if (this.addDefaultContactPerson) {
            this.contactPersons.add(this.defaultContactPerson);
        }
        for (ContactPerson contactPerson : this.contactPersons) {
            entityDescriptor.getContactPersons().add(contactPerson);
        }
        entityDescriptor.setID(this.id);
        if (this.signature.isPresent() && StringUtils.isNotEmpty((String)this.entityId)) {
            entityDescriptor.setSignature(this.signature.get());
            XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)entityDescriptor).marshall((XMLObject)entityDescriptor);
            if (this.shouldBeSigned) {
                Signer.signObject((Signature)entityDescriptor.getSignature());
            }
        }
        return entityDescriptor;
    }

    public EntityDescriptorBuilder withEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    public EntityDescriptorBuilder withOrganization(Organization organization) {
        this.organization = organization;
        return this;
    }

    public EntityDescriptorBuilder addContactPerson(ContactPerson contactPerson) {
        this.contactPersons.add(contactPerson);
        this.addDefaultContactPerson = false;
        return this;
    }

    public EntityDescriptorBuilder withIdpSsoDescriptor(IDPSSODescriptor descriptor) {
        this.idpSsoDescriptor = Optional.ofNullable(descriptor);
        return this;
    }

    public EntityDescriptorBuilder addSpServiceDescriptor(SPSSODescriptor descriptor) {
        this.spServiceDescriptors.add(descriptor);
        this.addDefaultSpServiceDescriptor = false;
        return this;
    }

    public EntityDescriptorBuilder setAddDefaultSpServiceDescriptor(boolean enabled) {
        this.addDefaultSpServiceDescriptor = enabled;
        return this;
    }

    public EntityDescriptorBuilder withValidUntil(DateTime validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public EntityDescriptorBuilder withCacheDuration(Long milliseconds) {
        this.cacheDuration = milliseconds;
        return this;
    }

    public EntityDescriptorBuilder withSignature(Signature signature) {
        this.signature = Optional.ofNullable(signature);
        return this;
    }

    public EntityDescriptorBuilder withoutSigning() {
        this.shouldBeSigned = false;
        return this;
    }

    public EntityDescriptorBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public EntityDescriptorBuilder withAttributeAuthorityDescriptor(AttributeAuthorityDescriptor descriptor) {
        this.attributeAuthorityDescriptor = Optional.ofNullable(descriptor);
        return this;
    }
}

