/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.Optional;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.test.builders.SubjectConfirmationDataBuilder;

public class SubjectConfirmationBuilder {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<String> method = Optional.of("urn:oasis:names:tc:SAML:2.0:cm:bearer");
    private Optional<SubjectConfirmationData> subjectConfirmationData = Optional.of(SubjectConfirmationDataBuilder.aSubjectConfirmationData().build());

    public static SubjectConfirmationBuilder aSubjectConfirmation() {
        return new SubjectConfirmationBuilder();
    }

    public SubjectConfirmation build() {
        SubjectConfirmation subjectConfirmation = this.openSamlXmlObjectFactory.createSubjectConfirmation();
        if (this.method.isPresent()) {
            subjectConfirmation.setMethod(this.method.get());
        }
        if (this.subjectConfirmationData.isPresent()) {
            subjectConfirmation.setSubjectConfirmationData(this.subjectConfirmationData.get());
        }
        return subjectConfirmation;
    }

    public SubjectConfirmationBuilder withMethod(String method) {
        this.method = Optional.ofNullable(method);
        return this;
    }

    public SubjectConfirmationBuilder withSubjectConfirmationData(SubjectConfirmationData subjectConfirmationData) {
        this.subjectConfirmationData = Optional.ofNullable(subjectConfirmationData);
        return this;
    }
}

