/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.algorithm.DigestAlgorithm;
import org.opensaml.xmlsec.algorithm.SignatureAlgorithm;
import org.opensaml.xmlsec.algorithm.descriptors.DigestSHA256;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA256;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.test.builders.AssertionBuilder;
import uk.gov.ida.saml.core.test.builders.AttributeStatementBuilder;
import uk.gov.ida.saml.core.test.builders.AuthnStatementBuilder;
import uk.gov.ida.saml.core.test.builders.IssuerBuilder;
import uk.gov.ida.saml.core.test.builders.SignatureBuilder;
import uk.gov.ida.saml.core.test.builders.StatusBuilder;

public class ResponseBuilder {
    private static OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    public static final String DEFAULT_REQUEST_ID = "_default-request-id_min-20-chars";
    public static final String DEFAULT_RESPONSE_ID = "_default-response-id_min-20-chars";
    private EncryptedAssertion defaultEncryptedAssertion;
    private boolean addDefaultEncryptedAssertionIfNoneIsAdded = true;
    private boolean shouldSign = true;
    private boolean shouldAddSignature = true;
    private SignatureAlgorithm signatureAlgorithm = new SignatureRSASHA256();
    private DigestAlgorithm digestAlgorithm = new DigestSHA256();
    private List<Assertion> assertions = new ArrayList<Assertion>();
    private List<EncryptedAssertion> encryptedAssertions = new ArrayList<EncryptedAssertion>();
    private Optional<Issuer> issuer = Optional.ofNullable(IssuerBuilder.anIssuer().build());
    private Optional<String> id = Optional.ofNullable("_default-response-id_min-20-chars");
    private Optional<DateTime> issueInstant = Optional.ofNullable(DateTime.now());
    private Optional<String> inResponseTo = Optional.ofNullable("_default-request-id_min-20-chars");
    private Optional<Status> status = Optional.ofNullable(StatusBuilder.aStatus().build());
    private Optional<Credential> signingCredential = Optional.empty();
    private Optional<String> destination = Optional.ofNullable("http://destination.com");

    public static ResponseBuilder aResponse() {
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.defaultEncryptedAssertion = AssertionBuilder.anAssertion().build();
        return responseBuilder;
    }

    public static ResponseBuilder aValidIdpResponse() {
        return ResponseBuilder.aResponse().withStatus(StatusBuilder.aStatus().build()).addAssertion(AssertionBuilder.anAssertion().addAttributeStatement(AttributeStatementBuilder.anAttributeStatement().build()).buildUnencrypted()).addAssertion(AssertionBuilder.anAssertion().addAuthnStatement(AuthnStatementBuilder.anAuthnStatement().build()).buildUnencrypted());
    }

    public Response build() throws MarshallingException, SignatureException {
        Response response = openSamlXmlObjectFactory.createResponse();
        if (this.id.isPresent()) {
            response.setID(this.id.get());
        }
        if (this.inResponseTo.isPresent()) {
            response.setInResponseTo(this.inResponseTo.get());
        }
        if (this.issueInstant.isPresent()) {
            response.setIssueInstant(this.issueInstant.get());
        }
        if (this.status.isPresent()) {
            response.setStatus(this.status.get());
        }
        if (this.destination.isPresent()) {
            response.setDestination(this.destination.get());
        }
        response.getAssertions().addAll(this.assertions);
        if (this.encryptedAssertions.isEmpty() && this.addDefaultEncryptedAssertionIfNoneIsAdded) {
            response.getEncryptedAssertions().add(this.defaultEncryptedAssertion);
        } else {
            response.getEncryptedAssertions().addAll(this.encryptedAssertions);
        }
        if (this.issuer.isPresent()) {
            response.setIssuer(this.issuer.get());
            if (!Strings.isNullOrEmpty((String)this.issuer.get().getValue()) && this.shouldAddSignature) {
                SignatureBuilder signatureBuilder = SignatureBuilder.aSignature().withSignatureAlgorithm(this.signatureAlgorithm);
                if (this.id.isPresent()) {
                    signatureBuilder.withDigestAlgorithm(this.id.get(), this.digestAlgorithm);
                }
                if (this.signingCredential.isPresent()) {
                    signatureBuilder.withSigningCredential(this.signingCredential.get());
                }
                response.setSignature(signatureBuilder.build());
                XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)response).marshall((XMLObject)response);
                if (this.shouldSign) {
                    Signer.signObject((Signature)response.getSignature());
                }
            }
        }
        return response;
    }

    public ResponseBuilder withIssuer(Issuer issuer) {
        this.issuer = Optional.ofNullable(issuer);
        return this;
    }

    public ResponseBuilder withId(String id) {
        this.id = Optional.ofNullable(id);
        return this;
    }

    public ResponseBuilder withInResponseTo(String requestId) {
        this.inResponseTo = Optional.ofNullable(requestId);
        return this;
    }

    public ResponseBuilder withIssueInstant(DateTime issueInstant) {
        this.issueInstant = Optional.ofNullable(issueInstant);
        return this;
    }

    public ResponseBuilder addAssertion(Assertion assertion) {
        this.addDefaultEncryptedAssertionIfNoneIsAdded = false;
        this.assertions.add(assertion);
        return this;
    }

    public ResponseBuilder withNoDefaultAssertion() {
        this.addDefaultEncryptedAssertionIfNoneIsAdded = false;
        return this;
    }

    public ResponseBuilder addEncryptedAssertion(EncryptedAssertion encryptedAssertion) {
        this.addDefaultEncryptedAssertionIfNoneIsAdded = false;
        this.encryptedAssertions.add(encryptedAssertion);
        return this;
    }

    public ResponseBuilder withoutSignatureElement() {
        this.shouldAddSignature = false;
        return this;
    }

    public ResponseBuilder withoutSigning() {
        this.shouldSign = false;
        return this;
    }

    public ResponseBuilder withStatus(Status status) {
        this.status = Optional.ofNullable(status);
        return this;
    }

    public ResponseBuilder withSigningCredential(Credential signingCredential) {
        this.signingCredential = Optional.ofNullable(signingCredential);
        return this;
    }

    public ResponseBuilder withDestination(String destination) {
        this.destination = Optional.ofNullable(destination);
        return this;
    }

    public ResponseBuilder withSignatureAlgorithm(@NotNull SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public ResponseBuilder withDigestAlgorithm(@NotNull DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }
}

