/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.Optional;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.AttributeValue;
import uk.gov.ida.saml.core.extensions.PersonName;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;

public class PersonNameAttributeValueBuilder {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<DateTime> from = Optional.empty();
    private Optional<DateTime> to = Optional.empty();
    private String value = "John";
    private Optional<String> language = Optional.empty();
    private Optional<Boolean> verified = Optional.empty();

    public static PersonNameAttributeValueBuilder aPersonNameValue() {
        return new PersonNameAttributeValueBuilder();
    }

    public AttributeValue build() {
        PersonName personNameAttributeValue = this.openSamlXmlObjectFactory.createPersonNameAttributeValue(this.value);
        this.from.ifPresent(arg_0 -> ((PersonName)personNameAttributeValue).setFrom(arg_0));
        this.to.ifPresent(arg_0 -> ((PersonName)personNameAttributeValue).setTo(arg_0));
        this.verified.ifPresent(arg_0 -> ((PersonName)personNameAttributeValue).setVerified(arg_0));
        this.language.ifPresent(arg_0 -> ((PersonName)personNameAttributeValue).setLanguage(arg_0));
        return personNameAttributeValue;
    }

    public PersonNameAttributeValueBuilder withFrom(DateTime from) {
        this.from = Optional.ofNullable(from);
        return this;
    }

    public PersonNameAttributeValueBuilder withTo(DateTime to) {
        this.to = Optional.ofNullable(to);
        return this;
    }

    public PersonNameAttributeValueBuilder withValue(String name) {
        this.value = name;
        return this;
    }

    public PersonNameAttributeValueBuilder withVerified(Boolean verified) {
        this.verified = Optional.ofNullable(verified);
        return this;
    }
}

