/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.ArrayList;
import java.util.List;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.test.builders.PersonNameAttributeValueBuilder;

public class PersonNameAttributeBuilder_1_1 {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private List<AttributeValue> values = new ArrayList<AttributeValue>();
    private String nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
    private boolean addDefaultValue = true;
    private AttributeValue defaultPersonNameAttributeValue = PersonNameAttributeValueBuilder.aPersonNameValue().build();

    public static PersonNameAttributeBuilder_1_1 aPersonName_1_1() {
        return new PersonNameAttributeBuilder_1_1();
    }

    public Attribute buildAsFirstname() {
        Attribute attribute = this.build();
        attribute.setFriendlyName("Firstname");
        attribute.setName("MDS_firstname");
        return attribute;
    }

    public Attribute buildAsSurname() {
        Attribute attribute = this.build();
        attribute.setFriendlyName("Surname");
        attribute.setName("MDS_surname");
        return attribute;
    }

    public Attribute buildAsMiddlename() {
        Attribute attribute = this.build();
        attribute.setFriendlyName("Middlename(s)");
        attribute.setName("MDS_middlename");
        return attribute;
    }

    public Attribute buildAsEidasFirstname() {
        Attribute attribute = this.build();
        attribute.setFriendlyName("FirstName");
        attribute.setName("http://eidas.europa.eu/attributes/naturalperson/CurrentGivenName");
        return attribute;
    }

    public Attribute buildAsEidasFamilyName() {
        Attribute attribute = this.build();
        attribute.setFriendlyName("FamilyName");
        attribute.setName("http://eidas.europa.eu/attributes/naturalperson/CurrentFamilyName");
        return attribute;
    }

    private Attribute build() {
        Attribute personNameAttribute = this.openSamlXmlObjectFactory.createAttribute();
        personNameAttribute.setNameFormat(this.nameFormat);
        if (this.addDefaultValue) {
            this.values.add(this.defaultPersonNameAttributeValue);
        }
        for (AttributeValue value : this.values) {
            personNameAttribute.getAttributeValues().add(value);
        }
        return personNameAttribute;
    }

    public Attribute buildAsFirstnameWithNoAttributeValues() {
        Attribute attribute = this.openSamlXmlObjectFactory.createAttribute();
        attribute.setNameFormat(this.nameFormat);
        attribute.setFriendlyName("Firstname");
        attribute.setName("MDS_firstname");
        return attribute;
    }

    public PersonNameAttributeBuilder_1_1 addValue(AttributeValue attributeValue) {
        this.values.add(attributeValue);
        this.addDefaultValue = false;
        return this;
    }

    public PersonNameAttributeBuilder_1_1 withNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
        return this;
    }
}

