/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import uk.gov.ida.saml.core.domain.Address;
import uk.gov.ida.saml.core.domain.AddressFactory;
import uk.gov.ida.saml.core.domain.Gender;
import uk.gov.ida.saml.core.domain.MatchingDataset;
import uk.gov.ida.saml.core.domain.SimpleMdsValue;
import uk.gov.ida.saml.core.domain.TransliterableMdsValue;
import uk.gov.ida.saml.core.test.builders.SimpleMdsValueBuilder;

public class MatchingDatasetBuilder {
    private List<TransliterableMdsValue> firstnames = new ArrayList<TransliterableMdsValue>();
    private List<SimpleMdsValue<String>> middleNames = new ArrayList<SimpleMdsValue<String>>();
    private List<TransliterableMdsValue> surnames = new ArrayList<TransliterableMdsValue>();
    private Optional<SimpleMdsValue<Gender>> gender = Optional.empty();
    private List<SimpleMdsValue<LocalDate>> dateOfBirths = new ArrayList<SimpleMdsValue<LocalDate>>();
    private List<Address> currentAddresses = new ArrayList<Address>();
    private List<Address> previousAddresses = new ArrayList<Address>();
    private String personalId = "default-pid";

    public static MatchingDatasetBuilder aMatchingDataset() {
        return new MatchingDatasetBuilder();
    }

    public static MatchingDatasetBuilder aFullyPopulatedMatchingDataset() {
        List<Address> currentAddressList = Arrays.asList(new AddressFactory().create(Arrays.asList("subject-address-line-1"), "subject-address-post-code", "internation-postcode", "uprn", DateTime.parse((String)"1999-03-15"), DateTime.parse((String)"2000-02-09"), true));
        List<Address> previousAddressList = Arrays.asList(new AddressFactory().create(Arrays.asList("previous-address-line-1"), "subject-address-post-code", "internation-postcode", "uprn", DateTime.parse((String)"1999-03-15"), DateTime.parse((String)"2000-02-09"), true));
        SimpleMdsValue<String> currentSurname = SimpleMdsValueBuilder.aSimpleMdsValue().withValue("subject-currentSurname").withVerifiedStatus(true).build();
        return MatchingDatasetBuilder.aMatchingDataset().addFirstname(SimpleMdsValueBuilder.aSimpleMdsValue().withValue("subject-firstname").withVerifiedStatus(true).build()).addMiddleNames(SimpleMdsValueBuilder.aSimpleMdsValue().withValue("subject-middlename").withVerifiedStatus(true).build()).withSurnameHistory(Arrays.asList(currentSurname)).withGender(SimpleMdsValueBuilder.aSimpleMdsValue().withValue(Gender.FEMALE).withVerifiedStatus(true).build()).addDateOfBirth(SimpleMdsValueBuilder.aSimpleMdsValue().withValue(LocalDate.parse((String)"2000-02-09")).withVerifiedStatus(true).build()).withCurrentAddresses(currentAddressList).withPreviousAddresses(previousAddressList);
    }

    public MatchingDataset build() {
        return new MatchingDataset(this.firstnames, this.middleNames, this.surnames, this.gender, this.dateOfBirths, this.currentAddresses, this.previousAddresses, this.personalId);
    }

    public MatchingDatasetBuilder addFirstname(SimpleMdsValue<String> firstname) {
        this.firstnames.add(new TransliterableMdsValue(firstname));
        return this;
    }

    public MatchingDatasetBuilder addMiddleNames(SimpleMdsValue<String> middleNames) {
        this.middleNames.add(middleNames);
        return this;
    }

    public MatchingDatasetBuilder addSurname(SimpleMdsValue<String> surname) {
        this.surnames.add(new TransliterableMdsValue(surname));
        return this;
    }

    public MatchingDatasetBuilder withGender(SimpleMdsValue<Gender> gender) {
        this.gender = Optional.ofNullable(gender);
        return this;
    }

    public MatchingDatasetBuilder withPersonalId(String personalId) {
        this.personalId = personalId;
        return this;
    }

    public MatchingDatasetBuilder addDateOfBirth(SimpleMdsValue<LocalDate> dateOfBirth) {
        this.dateOfBirths.add(dateOfBirth);
        return this;
    }

    public MatchingDatasetBuilder withCurrentAddresses(List<Address> currentAddresses) {
        this.currentAddresses = currentAddresses;
        return this;
    }

    public MatchingDatasetBuilder withPreviousAddresses(List<Address> previousAddresses) {
        this.previousAddresses = previousAddresses;
        return this;
    }

    public MatchingDatasetBuilder withoutFirstName() {
        this.firstnames.clear();
        return this;
    }

    public MatchingDatasetBuilder withoutMiddleName() {
        this.middleNames.clear();
        return this;
    }

    public MatchingDatasetBuilder withoutSurname() {
        this.surnames.clear();
        return this;
    }

    public MatchingDatasetBuilder withoutDateOfBirth() {
        this.dateOfBirths.clear();
        return this;
    }

    public MatchingDatasetBuilder withSurnameHistory(List<SimpleMdsValue<String>> surnameHistory) {
        this.surnames.clear();
        this.surnames.addAll(surnameHistory.stream().map(TransliterableMdsValue::new).collect(Collectors.toList()));
        return this;
    }
}

