/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.opensaml.saml.saml2.core.Attribute;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.extensions.IdpFraudEventId;
import uk.gov.ida.saml.core.extensions.StringValueSamlObject;
import uk.gov.ida.saml.core.extensions.impl.StringBasedMdsAttributeValueBuilder;

public class IdpFraudEventIdAttributeBuilder {
    private static final String INVALID_TYPE_LOCAL_NAME = "InvalidFraudEventType";
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<String> value = Optional.ofNullable("default-event-id");

    public static IdpFraudEventIdAttributeBuilder anIdpFraudEventIdAttribute() {
        return new IdpFraudEventIdAttributeBuilder();
    }

    public Attribute build() {
        Attribute attribute = this.openSamlXmlObjectFactory.createAttribute();
        attribute.setName("FECI_IDPFraudEventID");
        if (this.value.isPresent()) {
            IdpFraudEventId attributeValue = this.openSamlXmlObjectFactory.createIdpFraudEventAttributeValue(this.value.get());
            attribute.getAttributeValues().add(attributeValue);
        }
        return attribute;
    }

    public Attribute buildInvalidAttribute() {
        Attribute attribute = this.openSamlXmlObjectFactory.createAttribute();
        attribute.setName("FECI_IDPFraudEventID");
        if (this.value.isPresent()) {
            QName typeName = new QName("http://www.cabinetoffice.gov.uk/resource-library/ida/attributes", INVALID_TYPE_LOCAL_NAME, "ida");
            StringValueSamlObject idpFraudEventId = (StringValueSamlObject)new StringBasedMdsAttributeValueBuilder().buildObject(IdpFraudEventId.DEFAULT_ELEMENT_NAME, typeName);
            idpFraudEventId.setValue(this.value.get());
            attribute.getAttributeValues().add(idpFraudEventId);
        }
        return attribute;
    }

    public IdpFraudEventIdAttributeBuilder withValue(String value) {
        this.value = Optional.ofNullable(value);
        return this;
    }
}

