/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.Optional;
import uk.gov.ida.saml.core.domain.AuthnContext;
import uk.gov.ida.saml.core.domain.FraudAuthnDetails;
import uk.gov.ida.saml.core.domain.IdentityProviderAuthnStatement;
import uk.gov.ida.saml.core.domain.IpAddress;
import uk.gov.ida.saml.core.test.builders.IpAddressBuilder;

public class IdentityProviderAuthnStatementBuilder {
    private Optional<FraudAuthnDetails> fraudAuthnDetails = Optional.empty();
    private AuthnContext authnContext = AuthnContext.LEVEL_1;
    private Optional<IpAddress> userIpAddress = Optional.ofNullable(IpAddressBuilder.anIpAddress().build());

    public static IdentityProviderAuthnStatementBuilder anIdentityProviderAuthnStatement() {
        return new IdentityProviderAuthnStatementBuilder();
    }

    public IdentityProviderAuthnStatement build() {
        if (this.fraudAuthnDetails.isPresent()) {
            return IdentityProviderAuthnStatement.createIdentityProviderFraudAuthnStatement((FraudAuthnDetails)this.fraudAuthnDetails.get(), (IpAddress)this.userIpAddress.orElse(null));
        }
        return IdentityProviderAuthnStatement.createIdentityProviderAuthnStatement((AuthnContext)this.authnContext, (IpAddress)this.userIpAddress.orElse(null));
    }

    public IdentityProviderAuthnStatementBuilder withAuthnContext(AuthnContext authnContext) {
        this.authnContext = authnContext;
        return this;
    }

    public IdentityProviderAuthnStatementBuilder withFraudDetails(FraudAuthnDetails fraudDetails) {
        this.fraudAuthnDetails = Optional.ofNullable(fraudDetails);
        return this;
    }

    public IdentityProviderAuthnStatementBuilder withUserIpAddress(IpAddress userIpAddress) {
        this.userIpAddress = Optional.ofNullable(userIpAddress);
        return this;
    }
}

