/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.Optional;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.AttributeValue;
import uk.gov.ida.saml.core.extensions.Date;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;

public class DateAttributeValueBuilder {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<DateTime> from = Optional.empty();
    private Optional<DateTime> to = Optional.empty();
    private String value = "1991-04-12";
    private Optional<Boolean> verified = Optional.empty();

    public static DateAttributeValueBuilder aDateValue() {
        return new DateAttributeValueBuilder();
    }

    public AttributeValue build() {
        Date dateAttributeValue = this.openSamlXmlObjectFactory.createDateAttributeValue(this.value);
        if (this.from.isPresent()) {
            dateAttributeValue.setFrom(this.from.get());
        }
        if (this.to.isPresent()) {
            dateAttributeValue.setTo(this.to.get());
        }
        if (this.verified.isPresent()) {
            dateAttributeValue.setVerified(this.verified.get().booleanValue());
        }
        return dateAttributeValue;
    }

    public DateAttributeValueBuilder withFrom(DateTime from) {
        this.from = Optional.ofNullable(from);
        return this;
    }

    public DateAttributeValueBuilder withTo(DateTime to) {
        this.to = Optional.ofNullable(to);
        return this;
    }

    public DateAttributeValueBuilder withValue(String name) {
        this.value = name;
        return this;
    }

    public DateAttributeValueBuilder withVerified(Boolean verified) {
        this.verified = Optional.ofNullable(verified);
        return this;
    }
}

