/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import uk.gov.ida.common.shared.security.Certificate;
import uk.gov.ida.saml.core.test.TestCertificateStrings;

public class CertificateBuilder {
    private boolean useCertificateOfIssuerId = true;
    private String issuerId = "a-test-entity";
    private String certificate = null;
    private Certificate.KeyUse keyUse = Certificate.KeyUse.Signing;

    public static CertificateBuilder aCertificate() {
        return new CertificateBuilder();
    }

    public Certificate build() {
        if (this.useCertificateOfIssuerId) {
            this.certificate = this.keyUse == Certificate.KeyUse.Signing ? (String)TestCertificateStrings.PUBLIC_SIGNING_CERTS.get(this.issuerId) : TestCertificateStrings.getPrimaryPublicEncryptionCert((String)this.issuerId);
            if (this.certificate == null) {
                this.certificate = "Some certificate";
            }
        }
        return new Certificate(this.issuerId, this.certificate, this.keyUse);
    }

    public CertificateBuilder withIssuerId(String issuerID) {
        this.issuerId = issuerID;
        return this;
    }

    public CertificateBuilder withCertificate(String certificate) {
        this.useCertificateOfIssuerId = false;
        this.certificate = certificate;
        return this;
    }

    public CertificateBuilder withKeyUse(Certificate.KeyUse keyUse) {
        this.keyUse = keyUse;
        return this;
    }
}

