/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.Optional;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.test.builders.AuthnContextBuilder;
import uk.gov.ida.saml.core.test.builders.AuthnContextClassRefBuilder;

public class AuthnStatementBuilder {
    private static OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<AuthnContext> authnContext = Optional.ofNullable(AuthnContextBuilder.anAuthnContext().build());
    private Optional<DateTime> authnInstant = Optional.of(DateTime.now());

    public static AuthnStatementBuilder anAuthnStatement() {
        return new AuthnStatementBuilder();
    }

    public static AuthnStatementBuilder anEidasAuthnStatement(String level) {
        return AuthnStatementBuilder.anAuthnStatement().withAuthnContext(AuthnContextBuilder.anAuthnContext().withAuthnContextClassRef(AuthnContextClassRefBuilder.anAuthnContextClassRef().withAuthnContextClasRefValue(level).build()).build());
    }

    public AuthnStatement build() {
        AuthnStatement authnStatement = openSamlXmlObjectFactory.createAuthnStatement();
        if (this.authnContext.isPresent()) {
            authnStatement.setAuthnContext(this.authnContext.get());
        }
        if (this.authnInstant.isPresent()) {
            authnStatement.setAuthnInstant(this.authnInstant.get());
        }
        return authnStatement;
    }

    public AuthnStatementBuilder withAuthnContext(AuthnContext authnContext) {
        this.authnContext = Optional.ofNullable(authnContext);
        return this;
    }

    public AuthnStatementBuilder withAuthnInstant(DateTime authnInstant) {
        this.authnInstant = Optional.ofNullable(authnInstant);
        return this;
    }

    public AuthnStatementBuilder withId(String s) {
        throw new UnsupportedOperationException("Implement Me!");
    }
}

