/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import uk.gov.ida.saml.core.test.builders.IssuerBuilder;
import uk.gov.ida.saml.core.test.builders.SignatureBuilder;
import uk.gov.ida.saml.core.test.builders.SubjectBuilder;

public class AttributeQueryBuilder {
    private static final XMLObjectBuilderFactory factory = XMLObjectProviderRegistrySupport.getBuilderFactory();
    private boolean shouldSign = true;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private Optional<String> id = Optional.ofNullable("anId");
    private Optional<Subject> subject = Optional.ofNullable(SubjectBuilder.aSubject().build());
    private Optional<Issuer> issuer = Optional.ofNullable(IssuerBuilder.anIssuer().build());
    private Optional<Signature> signature = Optional.ofNullable(SignatureBuilder.aSignature().build());
    private Optional<DateTime> issueInstant = Optional.ofNullable(DateTime.now());

    public static AttributeQueryBuilder anAttributeQuery() {
        return new AttributeQueryBuilder();
    }

    public AttributeQuery build() {
        AttributeQuery attributeQuery = (AttributeQuery)factory.getBuilder(AttributeQuery.DEFAULT_ELEMENT_NAME).buildObject(AttributeQuery.DEFAULT_ELEMENT_NAME, AttributeQuery.TYPE_NAME);
        this.subject.ifPresent(arg_0 -> ((AttributeQuery)attributeQuery).setSubject(arg_0));
        this.issuer.ifPresent(arg_0 -> ((AttributeQuery)attributeQuery).setIssuer(arg_0));
        this.issueInstant.ifPresent(arg_0 -> ((AttributeQuery)attributeQuery).setIssueInstant(arg_0));
        this.id.ifPresent(arg_0 -> ((AttributeQuery)attributeQuery).setID(arg_0));
        if (this.signature.isPresent()) {
            attributeQuery.setSignature(this.signature.get());
            try {
                XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)attributeQuery).marshall((XMLObject)attributeQuery);
                if (this.shouldSign) {
                    Signer.signObject((Signature)attributeQuery.getSignature());
                }
            }
            catch (MarshallingException | SignatureException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        attributeQuery.getAttributes().addAll(this.attributes);
        return attributeQuery;
    }

    public AttributeQueryBuilder withSubject(Subject subject) {
        this.subject = Optional.ofNullable(subject);
        return this;
    }

    public AttributeQueryBuilder withoutSigning() {
        this.shouldSign = false;
        return this;
    }

    public AttributeQueryBuilder withId(String id) {
        this.id = Optional.ofNullable(id);
        return this;
    }

    public AttributeQueryBuilder withIssuer(Issuer issuer) {
        this.issuer = Optional.ofNullable(issuer);
        return this;
    }

    public AttributeQueryBuilder withIssueInstant(DateTime issueInstant) {
        this.issueInstant = Optional.ofNullable(issueInstant);
        return this;
    }

    public AttributeQueryBuilder withAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public AttributeQueryBuilder withSignature(Signature signature) {
        this.signature = Optional.ofNullable(signature);
        return this;
    }
}

