/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import uk.gov.ida.saml.core.extensions.Address;
import uk.gov.ida.saml.core.test.OpenSamlXmlObjectFactory;

public class AddressAttributeValueBuilder_1_1 {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<DateTime> from = Optional.empty();
    private Optional<DateTime> to = Optional.empty();
    private List<String> lines = new ArrayList<String>();
    private Optional<String> postCode = Optional.of("RG99 1YY");
    private Optional<String> internationalPostCode = Optional.of("RG88 1ZZ");
    private Optional<String> uprn = Optional.of("79347894352");
    private boolean verified = false;

    public static AddressAttributeValueBuilder_1_1 anAddressAttributeValue() {
        return new AddressAttributeValueBuilder_1_1();
    }

    public Address build() {
        Address addressAttributeValue = this.openSamlXmlObjectFactory.createAddressAttributeValue();
        if (this.from.isPresent()) {
            addressAttributeValue.setFrom(this.from.get());
        }
        if (this.to.isPresent()) {
            addressAttributeValue.setTo(this.to.get());
        }
        addressAttributeValue.setVerified(this.verified);
        for (String line : this.lines) {
            addressAttributeValue.getLines().add(this.openSamlXmlObjectFactory.createLine(line));
        }
        if (this.postCode.isPresent()) {
            addressAttributeValue.setPostCode(this.openSamlXmlObjectFactory.createPostCode(this.postCode.get()));
        }
        if (this.internationalPostCode.isPresent()) {
            addressAttributeValue.setInternationalPostCode(this.openSamlXmlObjectFactory.createInternationalPostCode(this.internationalPostCode.get()));
        }
        if (this.uprn.isPresent()) {
            addressAttributeValue.setUPRN(this.openSamlXmlObjectFactory.createUPRN(this.uprn.get()));
        }
        return addressAttributeValue;
    }

    public AddressAttributeValueBuilder_1_1 withFrom(DateTime from) {
        this.from = Optional.ofNullable(from);
        return this;
    }

    public AddressAttributeValueBuilder_1_1 withTo(DateTime to) {
        this.to = Optional.ofNullable(to);
        return this;
    }

    public AddressAttributeValueBuilder_1_1 addLines(List<String> lines) {
        this.lines.addAll(lines);
        return this;
    }

    public AddressAttributeValueBuilder_1_1 withVerified(boolean verified) {
        this.verified = verified;
        return this;
    }

    public AddressAttributeValueBuilder_1_1 withPostcode(String postCode) {
        this.postCode = Optional.ofNullable(postCode);
        return this;
    }

    public AddressAttributeValueBuilder_1_1 withInternationalPostcode(String internationalPostcode) {
        this.internationalPostCode = Optional.ofNullable(internationalPostcode);
        return this;
    }

    public AddressAttributeValueBuilder_1_1 withUprn(String uprn) {
        this.uprn = Optional.ofNullable(uprn);
        return this;
    }
}

