/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.util.encoders.Base64;
import uk.gov.ida.saml.security.EncryptionCredentialResolver;
import uk.gov.ida.saml.security.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.security.exception.SamlFailedToEncryptException;

public class SecretKeyEncrypter {
    private EncryptionCredentialResolver credentialFactory;

    public SecretKeyEncrypter(EncryptionCredentialResolver credentialFactory) {
        this.credentialFactory = credentialFactory;
    }

    public String encryptKeyForEntity(Key secretKey, String entityId) {
        PublicKey publicKey = this.credentialFactory.getEncryptingCredential(entityId).getPublicKey();
        try {
            Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
            cipher.init(3, publicKey);
            return Base64.toBase64String((byte[])cipher.wrap(secretKey));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SamlFailedToEncryptException(SamlTransformationErrorFactory.unableToEncryptXMLEncryptionKey(), e);
        }
    }
}

