/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata;

import com.codahale.metrics.health.HealthCheck;
import javax.inject.Inject;
import javax.inject.Named;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;

public class MetadataHealthCheck
extends HealthCheck {
    private final MetadataResolver metadataResolver;
    private final String expectedEntityId;
    private final String name;

    @Inject
    public MetadataHealthCheck(MetadataResolver metadataProvider, @Named(value="expectedEntityId") String expectedEntityId) {
        this(metadataProvider, "metadata", expectedEntityId);
    }

    @Inject
    public MetadataHealthCheck(MetadataResolver metadataProvider, String name, @Named(value="expectedEntityId") String expectedEntityId) {
        this.metadataResolver = metadataProvider;
        this.name = name;
        this.expectedEntityId = expectedEntityId;
    }

    public String getName() {
        return this.name;
    }

    protected HealthCheck.Result check() throws Exception {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.expectedEntityId)});
        EntityDescriptor entityDescriptor = (EntityDescriptor)this.metadataResolver.resolveSingle((Object)criteria);
        if (entityDescriptor != null) {
            return HealthCheck.Result.healthy();
        }
        return HealthCheck.Result.unhealthy((String)("Could not load: " + this.expectedEntityId + " from the metadata provider"));
    }
}

