/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.domain;

import com.google.inject.Inject;
import java.util.List;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import uk.gov.ida.saml.core.transformers.outbound.decorators.AbstractAssertionEncrypter;
import uk.gov.ida.saml.security.EncrypterFactory;
import uk.gov.ida.saml.security.EntityToEncryptForLocator;
import uk.gov.ida.saml.security.KeyStoreBackedEncryptionCredentialResolver;

public class SamlAttributeQueryAssertionEncrypter
extends AbstractAssertionEncrypter<AttributeQuery> {
    @Inject
    public SamlAttributeQueryAssertionEncrypter(KeyStoreBackedEncryptionCredentialResolver credentialResolver, EncrypterFactory encrypterFactory, EntityToEncryptForLocator entityToEncryptForLocator) {
        super(encrypterFactory, entityToEncryptForLocator, credentialResolver);
    }

    @Override
    protected String getRequestId(AttributeQuery attributeQuery) {
        return attributeQuery.getID();
    }

    @Override
    protected List<EncryptedAssertion> getEncryptedAssertions(AttributeQuery attributeQuery) {
        SubjectConfirmationData subjectConfirmationData = ((SubjectConfirmation)attributeQuery.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData();
        return subjectConfirmationData.getUnknownXMLObjects(Assertion.DEFAULT_ELEMENT_NAME);
    }

    @Override
    protected List<Assertion> getAssertions(AttributeQuery attributeQuery) {
        SubjectConfirmationData subjectConfirmationData = ((SubjectConfirmation)attributeQuery.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData();
        return subjectConfirmationData.getUnknownXMLObjects(Assertion.DEFAULT_ELEMENT_NAME);
    }
}

