/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security.validators.encryptedelementtype;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opensaml.saml.saml2.core.EncryptedElementType;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.security.errors.SamlTransformationErrorFactory;

public class EncryptionAlgorithmValidator {
    private final Set<String> algorithmWhitelist;
    private final Set<String> keyTransportAlgorithmWhitelist;

    public EncryptionAlgorithmValidator() {
        this.algorithmWhitelist = ImmutableSet.of((Object)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.keyTransportAlgorithmWhitelist = ImmutableSet.of((Object)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
    }

    public EncryptionAlgorithmValidator(Set<String> algorithmWhitelist, Set<String> keyTransportAlgorithmWhitelist) {
        this.algorithmWhitelist = algorithmWhitelist;
        this.keyTransportAlgorithmWhitelist = keyTransportAlgorithmWhitelist;
    }

    public void validate(EncryptedElementType encryptedElement) {
        EncryptionMethod encryptionMethod;
        String algorithm = encryptedElement.getEncryptedData().getEncryptionMethod().getAlgorithm();
        if (!this.algorithmWhitelist.contains(algorithm)) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.unsupportedEncryptionAlgortithm(algorithm);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (encryptedElement.getEncryptedKeys().size() != 0) {
            encryptionMethod = ((EncryptedKey)encryptedElement.getEncryptedKeys().get(0)).getEncryptionMethod();
        } else if (encryptedElement.getEncryptedData().getKeyInfo().getEncryptedKeys().size() != 0) {
            encryptionMethod = ((EncryptedKey)encryptedElement.getEncryptedData().getKeyInfo().getEncryptedKeys().get(0)).getEncryptionMethod();
        } else {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.unableToLocateEncryptedKey();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        String keyTransportAlgorithm = encryptionMethod.getAlgorithm();
        if (!this.keyTransportAlgorithmWhitelist.contains(keyTransportAlgorithm)) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.unsupportedKeyEncryptionAlgorithm(keyTransportAlgorithm);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }
}

