/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.deserializers;

import java.util.function.Function;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Element;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.core.validation.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.deserializers.parser.SamlObjectParser;

public class ElementToOpenSamlXMLObjectTransformer<TOutput extends XMLObject>
implements Function<Element, TOutput> {
    private final SamlObjectParser samlObjectParser;

    public ElementToOpenSamlXMLObjectTransformer(SamlObjectParser samlObjectParser) {
        this.samlObjectParser = samlObjectParser;
    }

    @Override
    public TOutput apply(Element input) {
        try {
            return (TOutput)this.samlObjectParser.getSamlObject(input);
        }
        catch (UnmarshallingException e) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.unableToUnmarshallElementToOpenSaml(input.getLocalName());
            throw new SamlTransformationErrorException(failure.getErrorMessage(), (Exception)((Object)e), failure.getLogLevel());
        }
    }
}

