/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core;

import javax.validation.constraints.NotNull;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusDetail;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.AttributeService;
import org.opensaml.saml.saml2.metadata.Company;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml.saml2.metadata.OrganizationName;
import org.opensaml.saml.saml2.metadata.OrganizationURL;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml.saml2.metadata.SurName;
import org.opensaml.saml.saml2.metadata.TelephoneNumber;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import uk.gov.ida.saml.core.SignatureAlgorithm;
import uk.gov.ida.saml.core.extensions.Address;
import uk.gov.ida.saml.core.extensions.Date;
import uk.gov.ida.saml.core.extensions.Gender;
import uk.gov.ida.saml.core.extensions.Gpg45Status;
import uk.gov.ida.saml.core.extensions.IPAddress;
import uk.gov.ida.saml.core.extensions.IdpFraudEventId;
import uk.gov.ida.saml.core.extensions.InternationalPostCode;
import uk.gov.ida.saml.core.extensions.Line;
import uk.gov.ida.saml.core.extensions.PersonName;
import uk.gov.ida.saml.core.extensions.PostCode;
import uk.gov.ida.saml.core.extensions.StatusValue;
import uk.gov.ida.saml.core.extensions.StringBasedMdsAttributeValue;
import uk.gov.ida.saml.core.extensions.UPRN;
import uk.gov.ida.saml.core.extensions.Verified;

public class OpenSamlXmlObjectFactory {
    private XMLObjectBuilderFactory openSamlBuilderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();

    public Subject createSubject() {
        return (Subject)this.openSamlBuilderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME).buildObject(Subject.DEFAULT_ELEMENT_NAME, Subject.TYPE_NAME);
    }

    public AttributeQuery createAttributeQuery() {
        return (AttributeQuery)this.openSamlBuilderFactory.getBuilder(AttributeQuery.DEFAULT_ELEMENT_NAME).buildObject(AttributeQuery.DEFAULT_ELEMENT_NAME, AttributeQuery.TYPE_NAME);
    }

    public NameID createNameId(String nameId) {
        NameID retVal = (NameID)this.openSamlBuilderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME).buildObject(NameID.DEFAULT_ELEMENT_NAME);
        retVal.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        retVal.setValue(nameId);
        return retVal;
    }

    public Issuer createIssuer(String issuer) {
        Issuer retVal = (Issuer)this.openSamlBuilderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME).buildObject(Issuer.DEFAULT_ELEMENT_NAME);
        retVal.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        retVal.setValue(issuer);
        return retVal;
    }

    public Status createStatus() {
        return (Status)this.openSamlBuilderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME).buildObject(Status.DEFAULT_ELEMENT_NAME, Status.TYPE_NAME);
    }

    public StatusMessage createStatusMessage() {
        return (StatusMessage)this.openSamlBuilderFactory.getBuilder(StatusMessage.DEFAULT_ELEMENT_NAME).buildObject(StatusMessage.DEFAULT_ELEMENT_NAME);
    }

    public StatusCode createStatusCode() {
        return (StatusCode)this.openSamlBuilderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME).buildObject(StatusCode.DEFAULT_ELEMENT_NAME, StatusCode.TYPE_NAME);
    }

    public Attribute createAttribute() {
        return (Attribute)this.openSamlBuilderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME).buildObject(Attribute.DEFAULT_ELEMENT_NAME, Attribute.TYPE_NAME);
    }

    public AttributeStatement createAttributeStatement() {
        return (AttributeStatement)this.openSamlBuilderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME).buildObject(AttributeStatement.DEFAULT_ELEMENT_NAME, AttributeStatement.TYPE_NAME);
    }

    public Response createResponse() {
        return (Response)this.openSamlBuilderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME).buildObject(Response.DEFAULT_ELEMENT_NAME, Response.TYPE_NAME);
    }

    public Assertion createAssertion() {
        return (Assertion)this.openSamlBuilderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME).buildObject(Assertion.DEFAULT_ELEMENT_NAME, Assertion.TYPE_NAME);
    }

    public SubjectConfirmation createSubjectConfirmation() {
        return (SubjectConfirmation)this.openSamlBuilderFactory.getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME).buildObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME, SubjectConfirmation.TYPE_NAME);
    }

    public SubjectConfirmationData createSubjectConfirmationData() {
        return (SubjectConfirmationData)this.openSamlBuilderFactory.getBuilder(SubjectConfirmationData.DEFAULT_ELEMENT_NAME).buildObject(SubjectConfirmationData.DEFAULT_ELEMENT_NAME, SubjectConfirmationData.TYPE_NAME);
    }

    public AuthnRequest createAuthnRequest() {
        return (AuthnRequest)this.openSamlBuilderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME).buildObject(AuthnRequest.DEFAULT_ELEMENT_NAME, AuthnRequest.TYPE_NAME);
    }

    private Audience createAudience(String audienceId) {
        Audience audience = (Audience)this.openSamlBuilderFactory.getBuilder(Audience.DEFAULT_ELEMENT_NAME).buildObject(Audience.DEFAULT_ELEMENT_NAME);
        audience.setAudienceURI(audienceId);
        return audience;
    }

    public AudienceRestriction createAudienceRestriction(String audienceId) {
        Audience audience = this.createAudience(audienceId);
        AudienceRestriction audienceRestriction = (AudienceRestriction)this.openSamlBuilderFactory.getBuilder(AudienceRestriction.DEFAULT_ELEMENT_NAME).buildObject(AudienceRestriction.DEFAULT_ELEMENT_NAME, AudienceRestriction.TYPE_NAME);
        audienceRestriction.getAudiences().add(audience);
        return audienceRestriction;
    }

    public Conditions createConditions() {
        return (Conditions)this.openSamlBuilderFactory.getBuilder(Conditions.DEFAULT_ELEMENT_NAME).buildObject(Conditions.DEFAULT_ELEMENT_NAME, Conditions.TYPE_NAME);
    }

    public Scoping createScoping() {
        return (Scoping)this.openSamlBuilderFactory.getBuilder(Scoping.DEFAULT_ELEMENT_NAME).buildObject(Scoping.DEFAULT_ELEMENT_NAME);
    }

    public RequestedAuthnContext createRequestedAuthnContext(AuthnContextComparisonTypeEnumeration authnContextComparisonTypeEnumeration) {
        RequestedAuthnContext requestedAuthnContext = (RequestedAuthnContext)this.openSamlBuilderFactory.getBuilder(RequestedAuthnContext.DEFAULT_ELEMENT_NAME).buildObject(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        requestedAuthnContext.setComparison(authnContextComparisonTypeEnumeration);
        return requestedAuthnContext;
    }

    public AuthnContext createAuthnContext() {
        return (AuthnContext)this.openSamlBuilderFactory.getBuilder(AuthnContext.DEFAULT_ELEMENT_NAME).buildObject(AuthnContext.DEFAULT_ELEMENT_NAME);
    }

    public AuthnContextClassRef createAuthnContextClassReference(String authnContextUrn) {
        AuthnContextClassRef authnContextClassRef = (AuthnContextClassRef)this.openSamlBuilderFactory.getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME).buildObject(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        authnContextClassRef.setAuthnContextClassRef(authnContextUrn);
        return authnContextClassRef;
    }

    public NameIDPolicy createNameIdPolicy() {
        return (NameIDPolicy)this.openSamlBuilderFactory.getBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME).buildObject(NameIDPolicy.DEFAULT_ELEMENT_NAME, NameIDPolicy.TYPE_NAME);
    }

    public Address createAddressAttributeValue() {
        return (Address)this.openSamlBuilderFactory.getBuilder(Address.TYPE_NAME).buildObject(Address.DEFAULT_ELEMENT_NAME, Address.TYPE_NAME);
    }

    public PostCode createPostCode(String postCode) {
        PostCode postCodeObject = (PostCode)this.openSamlBuilderFactory.getBuilder(PostCode.DEFAULT_ELEMENT_NAME).buildObject(PostCode.DEFAULT_ELEMENT_NAME);
        postCodeObject.setValue(postCode);
        return postCodeObject;
    }

    public InternationalPostCode createInternationalPostCode(String internationalPostCode) {
        InternationalPostCode internationalPostCodeObject = (InternationalPostCode)this.openSamlBuilderFactory.getBuilder(InternationalPostCode.DEFAULT_ELEMENT_NAME).buildObject(InternationalPostCode.DEFAULT_ELEMENT_NAME);
        internationalPostCodeObject.setValue(internationalPostCode);
        return internationalPostCodeObject;
    }

    public UPRN createUPRN(String uprn) {
        UPRN uprnObject = (UPRN)this.openSamlBuilderFactory.getBuilder(UPRN.DEFAULT_ELEMENT_NAME).buildObject(UPRN.DEFAULT_ELEMENT_NAME);
        uprnObject.setValue(uprn);
        return uprnObject;
    }

    public Line createLine(String line) {
        Line lineObject = (Line)this.openSamlBuilderFactory.getBuilder(Line.DEFAULT_ELEMENT_NAME).buildObject(Line.DEFAULT_ELEMENT_NAME);
        lineObject.setValue(line);
        return lineObject;
    }

    public PersonName createPersonNameAttributeValue(String name) {
        PersonName personNameObject = (PersonName)this.openSamlBuilderFactory.getBuilder(PersonName.TYPE_NAME).buildObject(PersonName.DEFAULT_ELEMENT_NAME, PersonName.TYPE_NAME);
        personNameObject.setValue(name);
        personNameObject.setLanguage("en-GB");
        return personNameObject;
    }

    public Gender createGenderAttributeValue(String value) {
        Gender genderObject = (Gender)this.openSamlBuilderFactory.getBuilder(Gender.TYPE_NAME).buildObject(Gender.DEFAULT_ELEMENT_NAME, Gender.TYPE_NAME);
        genderObject.setValue(value);
        return genderObject;
    }

    public Date createDateAttributeValue(String dateTime) {
        Date dateObject = (Date)this.openSamlBuilderFactory.getBuilder(Date.TYPE_NAME).buildObject(Date.DEFAULT_ELEMENT_NAME, Date.TYPE_NAME);
        dateObject.setValue(dateTime);
        return dateObject;
    }

    public Verified createVerifiedAttributeValue(boolean value) {
        Verified verifiedObject = (Verified)this.openSamlBuilderFactory.getBuilder(Verified.TYPE_NAME).buildObject(Verified.DEFAULT_ELEMENT_NAME, Verified.TYPE_NAME);
        verifiedObject.setValue(value);
        return verifiedObject;
    }

    public AuthnStatement createAuthnStatement() {
        return (AuthnStatement)this.openSamlBuilderFactory.getBuilder(AuthnStatement.TYPE_NAME).buildObject(AuthnStatement.DEFAULT_ELEMENT_NAME, AuthnStatement.TYPE_NAME);
    }

    public EntityDescriptor createEntityDescriptor() {
        return (EntityDescriptor)this.openSamlBuilderFactory.getBuilder(EntityDescriptor.TYPE_NAME).buildObject(EntityDescriptor.DEFAULT_ELEMENT_NAME, EntityDescriptor.TYPE_NAME);
    }

    public Organization createOrganization() {
        return (Organization)this.openSamlBuilderFactory.getBuilder(Organization.TYPE_NAME).buildObject(Organization.DEFAULT_ELEMENT_NAME, Organization.TYPE_NAME);
    }

    public SingleSignOnService createSingleSignOnService(String binding, String location) {
        SingleSignOnService singleSignOnService = (SingleSignOnService)this.openSamlBuilderFactory.getBuilder(SingleSignOnService.DEFAULT_ELEMENT_NAME).buildObject(SingleSignOnService.DEFAULT_ELEMENT_NAME, SingleSignOnService.TYPE_NAME);
        singleSignOnService.setBinding(binding);
        singleSignOnService.setLocation(location);
        return singleSignOnService;
    }

    public AssertionConsumerService createAssertionConsumerService(String binding, String location, Integer index, boolean isDefault) {
        AssertionConsumerService assertionConsumerService = (AssertionConsumerService)this.openSamlBuilderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME).buildObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME, AssertionConsumerService.TYPE_NAME);
        assertionConsumerService.setBinding(binding);
        assertionConsumerService.setLocation(location);
        assertionConsumerService.setIndex(index);
        assertionConsumerService.setIsDefault(Boolean.valueOf(isDefault));
        return assertionConsumerService;
    }

    public IDPSSODescriptor createIDPSSODescriptor() {
        return (IDPSSODescriptor)this.openSamlBuilderFactory.getBuilder(IDPSSODescriptor.DEFAULT_ELEMENT_NAME).buildObject(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, IDPSSODescriptor.TYPE_NAME);
    }

    public SPSSODescriptor createSPSSODescriptor() {
        return (SPSSODescriptor)this.openSamlBuilderFactory.getBuilder(SPSSODescriptor.DEFAULT_ELEMENT_NAME).buildObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME, SPSSODescriptor.TYPE_NAME);
    }

    public AttributeAuthorityDescriptor createAttributeAuthorityDescriptor() {
        return (AttributeAuthorityDescriptor)this.openSamlBuilderFactory.getBuilder(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME).buildObject(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME);
    }

    public AttributeService createAttributeService() {
        return (AttributeService)this.openSamlBuilderFactory.getBuilder(AttributeService.DEFAULT_ELEMENT_NAME).buildObject(AttributeService.DEFAULT_ELEMENT_NAME);
    }

    public OrganizationDisplayName createOrganizationDisplayName(String name) {
        OrganizationDisplayName organizationDisplayName = (OrganizationDisplayName)this.openSamlBuilderFactory.getBuilder(OrganizationDisplayName.DEFAULT_ELEMENT_NAME).buildObject(OrganizationDisplayName.DEFAULT_ELEMENT_NAME, OrganizationDisplayName.TYPE_NAME);
        organizationDisplayName.setValue(name);
        organizationDisplayName.setXMLLang("en-GB");
        return organizationDisplayName;
    }

    public OrganizationName createOrganizationName(String name) {
        OrganizationName organizationName = (OrganizationName)this.openSamlBuilderFactory.getBuilder(OrganizationName.DEFAULT_ELEMENT_NAME).buildObject(OrganizationName.DEFAULT_ELEMENT_NAME, OrganizationName.TYPE_NAME);
        organizationName.setValue(name);
        organizationName.setXMLLang("en-GB");
        return organizationName;
    }

    public OrganizationURL createOrganizationUrl(String url) {
        OrganizationURL organizationUrl = (OrganizationURL)this.openSamlBuilderFactory.getBuilder(OrganizationURL.DEFAULT_ELEMENT_NAME).buildObject(OrganizationURL.DEFAULT_ELEMENT_NAME, OrganizationURL.TYPE_NAME);
        organizationUrl.setValue(url);
        organizationUrl.setXMLLang("en-GB");
        return organizationUrl;
    }

    public KeyDescriptor createKeyDescriptor(String use) {
        KeyDescriptor keyDescriptor = (KeyDescriptor)this.openSamlBuilderFactory.getBuilder(KeyDescriptor.DEFAULT_ELEMENT_NAME).buildObject(KeyDescriptor.DEFAULT_ELEMENT_NAME, KeyDescriptor.TYPE_NAME);
        keyDescriptor.setUse(UsageType.valueOf((String)use.toUpperCase()));
        return keyDescriptor;
    }

    public X509Certificate createX509Certificate(String cert) {
        X509Certificate x509Certificate = (X509Certificate)this.openSamlBuilderFactory.getBuilder(X509Certificate.DEFAULT_ELEMENT_NAME).buildObject(X509Certificate.DEFAULT_ELEMENT_NAME);
        x509Certificate.setValue(cert);
        return x509Certificate;
    }

    public X509Data createX509Data() {
        return (X509Data)this.openSamlBuilderFactory.getBuilder(X509Data.DEFAULT_ELEMENT_NAME).buildObject(X509Data.DEFAULT_ELEMENT_NAME, X509Data.TYPE_NAME);
    }

    public KeyInfo createKeyInfo(String keyNameValue) {
        KeyInfo keyInfo = (KeyInfo)this.openSamlBuilderFactory.getBuilder(KeyInfo.DEFAULT_ELEMENT_NAME).buildObject(KeyInfo.DEFAULT_ELEMENT_NAME, KeyInfo.TYPE_NAME);
        if (keyNameValue != null) {
            KeyName keyName = this.createKeyName(keyNameValue);
            keyInfo.getKeyNames().add(keyName);
        }
        return keyInfo;
    }

    public KeyInfo createKeyInfo(String issuerId, String certificateValue) {
        KeyInfo keyInfo = this.createKeyInfo(issuerId);
        X509Data x509Data = this.createX509Data();
        X509Certificate x509Certificate = this.createX509Certificate(certificateValue);
        x509Data.getX509Certificates().add(x509Certificate);
        keyInfo.getX509Datas().add(x509Data);
        return keyInfo;
    }

    private KeyName createKeyName(String keyNameValue) {
        KeyName keyName = (KeyName)this.openSamlBuilderFactory.getBuilder(KeyName.DEFAULT_ELEMENT_NAME).buildObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(keyNameValue);
        return keyName;
    }

    public Signature createSignature() {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        XMLObjectBuilder builder = builderFactory.getBuilder(Signature.DEFAULT_ELEMENT_NAME);
        XMLObject xmlObject = builder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        Signature signature = (Signature)xmlObject;
        signature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        return signature;
    }

    public Signature createSignature(@NotNull Credential signingCredential) {
        Signature signature = this.createSignature();
        signature.setSigningCredential(signingCredential);
        return signature;
    }

    public Signature createSignature(@NotNull SignatureAlgorithm signatureAlgorithm) {
        Signature signature = this.createSignature();
        signature.setSignatureAlgorithm(signatureAlgorithm.toString());
        return signature;
    }

    public Signature createSignature(@NotNull Credential signingCredential, @NotNull SignatureAlgorithm signatureAlgorithm) {
        Signature signature = this.createSignature(signingCredential);
        signature.setSignatureAlgorithm(signatureAlgorithm.toString());
        return signature;
    }

    public SAMLVersion createSamlVersion(String samlVersion) {
        return SAMLVersion.valueOf((String)samlVersion);
    }

    public ContactPerson createContactPerson() {
        return (ContactPerson)this.openSamlBuilderFactory.getBuilder(ContactPerson.DEFAULT_ELEMENT_NAME).buildObject(ContactPerson.DEFAULT_ELEMENT_NAME, new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ContactType", "md"));
    }

    public EmailAddress createEmailAddress(String address) {
        EmailAddress emailAddress = (EmailAddress)this.openSamlBuilderFactory.getBuilder(EmailAddress.DEFAULT_ELEMENT_NAME).buildObject(EmailAddress.DEFAULT_ELEMENT_NAME);
        emailAddress.setAddress(address);
        return emailAddress;
    }

    public TelephoneNumber createTelephoneNumber(String number) {
        TelephoneNumber telephoneNumber = (TelephoneNumber)this.openSamlBuilderFactory.getBuilder(TelephoneNumber.DEFAULT_ELEMENT_NAME).buildObject(TelephoneNumber.DEFAULT_ELEMENT_NAME);
        telephoneNumber.setNumber(number);
        return telephoneNumber;
    }

    public GivenName createGivenName(String name) {
        GivenName givenName = (GivenName)this.openSamlBuilderFactory.getBuilder(GivenName.DEFAULT_ELEMENT_NAME).buildObject(GivenName.DEFAULT_ELEMENT_NAME);
        givenName.setName(name);
        return givenName;
    }

    public SurName createSurName(String name) {
        SurName surName = (SurName)this.openSamlBuilderFactory.getBuilder(SurName.DEFAULT_ELEMENT_NAME).buildObject(SurName.DEFAULT_ELEMENT_NAME);
        surName.setName(name);
        return surName;
    }

    public Company createCompany(String name) {
        Company company = (Company)this.openSamlBuilderFactory.getBuilder(Company.DEFAULT_ELEMENT_NAME).buildObject(Company.DEFAULT_ELEMENT_NAME);
        company.setName(name);
        return company;
    }

    public StringBasedMdsAttributeValue createSimpleMdsAttributeValue(String value) {
        StringBasedMdsAttributeValue stringBasedMdsAttributeValue = (StringBasedMdsAttributeValue)this.openSamlBuilderFactory.getBuilder(StringBasedMdsAttributeValue.TYPE_NAME).buildObject(StringBasedMdsAttributeValue.DEFAULT_ELEMENT_NAME, StringBasedMdsAttributeValue.TYPE_NAME);
        stringBasedMdsAttributeValue.setValue(value);
        return stringBasedMdsAttributeValue;
    }

    public IdpFraudEventId createIdpFraudEventAttributeValue(String fraudEventId) {
        IdpFraudEventId idpFraudEventId = (IdpFraudEventId)this.openSamlBuilderFactory.getBuilder(IdpFraudEventId.TYPE_NAME).buildObject(IdpFraudEventId.DEFAULT_ELEMENT_NAME, IdpFraudEventId.TYPE_NAME);
        idpFraudEventId.setValue(fraudEventId);
        return idpFraudEventId;
    }

    public Gpg45Status createGpg45StatusAttributeValue(String indicator) {
        Gpg45Status gpg45Status = (Gpg45Status)this.openSamlBuilderFactory.getBuilder(Gpg45Status.TYPE_NAME).buildObject(Gpg45Status.DEFAULT_ELEMENT_NAME, Gpg45Status.TYPE_NAME);
        gpg45Status.setValue(indicator);
        return gpg45Status;
    }

    public IPAddress createIPAddressAttributeValue(String value) {
        IPAddress ipAddressObject = (IPAddress)this.openSamlBuilderFactory.getBuilder(IPAddress.TYPE_NAME).buildObject(IPAddress.DEFAULT_ELEMENT_NAME, IPAddress.TYPE_NAME);
        ipAddressObject.setValue(value);
        return ipAddressObject;
    }

    public StatusValue createStatusValue(String value) {
        StatusValue statusValue = (StatusValue)this.openSamlBuilderFactory.getBuilder(StatusValue.DEFAULT_ELEMENT_NAME).buildObject(StatusValue.DEFAULT_ELEMENT_NAME);
        statusValue.setValue(value);
        return statusValue;
    }

    public StatusDetail createStatusDetail() {
        StatusDetail statusDetail = (StatusDetail)this.openSamlBuilderFactory.getBuilder(StatusDetail.DEFAULT_ELEMENT_NAME).buildObject(StatusDetail.DEFAULT_ELEMENT_NAME);
        return statusDetail;
    }
}

