/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedElementType;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdaDecrypter
extends Decrypter {
    private static final Logger LOG = LoggerFactory.getLogger(IdaDecrypter.class);

    public IdaDecrypter(KeyInfoCredentialResolver newResolver, KeyInfoCredentialResolver newKEKResolver, EncryptedKeyResolver newEncKeyResolver) {
        super(newResolver, newKEKResolver, newEncKeyResolver);
    }

    public Assertion decrypt(EncryptedAssertion encryptedAssertion) throws DecryptionException {
        SAMLObject samlObject = this.decryptData((EncryptedElementType)encryptedAssertion);
        if (!(samlObject instanceof Assertion)) {
            throw new DecryptionException("Decrypted SAMLObject was not an instance of Assertion");
        }
        return (Assertion)samlObject;
    }

    private SAMLObject decryptData(EncryptedElementType encElement) throws DecryptionException {
        XMLObject xmlObject;
        if (encElement.getEncryptedData() == null) {
            throw new DecryptionException("Element had no EncryptedData child");
        }
        try {
            xmlObject = this.decryptData(encElement.getEncryptedData(), this.isRootInNewDocument());
        }
        catch (DecryptionException e) {
            LOG.error("SAML Decrypter encountered an error decrypting element content", (Throwable)e);
            throw e;
        }
        if (!(xmlObject instanceof SAMLObject)) {
            throw new DecryptionException("Decrypted XMLObject was not an instance of SAMLObject");
        }
        return (SAMLObject)xmlObject;
    }
}

