/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers;

import java.text.MessageFormat;
import javax.inject.Inject;
import uk.gov.ida.saml.core.domain.AuthnContext;

public class AuthnContextFactory {
    public static final String LEVEL_OF_ASSURANCE_IS_NOT_A_RECOGNISED_VALUE = "Level of assurance ''{0}'' is not a recognised value.";

    @Inject
    public AuthnContextFactory() {
    }

    public AuthnContext authnContextForLevelOfAssurance(String levelOfAssurance) {
        switch (levelOfAssurance) {
            case "urn:uk:gov:cabinet-office:tc:saml:authn-context:level1": {
                return AuthnContext.LEVEL_1;
            }
            case "urn:uk:gov:cabinet-office:tc:saml:authn-context:level2": {
                return AuthnContext.LEVEL_2;
            }
            case "urn:uk:gov:cabinet-office:tc:saml:authn-context:level3": {
                return AuthnContext.LEVEL_3;
            }
            case "urn:uk:gov:cabinet-office:tc:saml:authn-context:level4": {
                return AuthnContext.LEVEL_4;
            }
            case "urn:uk:gov:cabinet-office:tc:saml:authn-context:levelX": {
                return AuthnContext.LEVEL_X;
            }
        }
        throw new IllegalStateException(MessageFormat.format(LEVEL_OF_ASSURANCE_IS_NOT_A_RECOGNISED_VALUE, levelOfAssurance));
    }
}

