/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers.outbound;

import java.util.function.Function;
import javax.inject.Inject;
import org.opensaml.saml.saml2.core.Response;
import org.w3c.dom.Element;
import uk.gov.ida.saml.core.transformers.outbound.decorators.ResponseAssertionSigner;
import uk.gov.ida.saml.core.transformers.outbound.decorators.ResponseSignatureCreator;
import uk.gov.ida.saml.core.transformers.outbound.decorators.SamlResponseAssertionEncrypter;
import uk.gov.ida.saml.core.transformers.outbound.decorators.SamlSignatureSigner;
import uk.gov.ida.saml.serializers.XmlObjectToElementTransformer;

public class ResponseToElementTransformer
implements Function<Response, Element> {
    private final XmlObjectToElementTransformer<Response> xmlObjectToElementTransformer;
    private final SamlSignatureSigner<Response> samlSignatureSigner;
    private final SamlResponseAssertionEncrypter samlResponseAssertionEncrypter;
    private final ResponseAssertionSigner responseAssertionSigner;
    private final ResponseSignatureCreator responseSignatureCreator;

    @Inject
    public ResponseToElementTransformer(XmlObjectToElementTransformer<Response> xmlObjectToElementTransformer, SamlSignatureSigner<Response> samlSignatureSigner, SamlResponseAssertionEncrypter samlResponseAssertionEncrypter, ResponseAssertionSigner responseAssertionSigner, ResponseSignatureCreator responseSignatureCreator) {
        this.xmlObjectToElementTransformer = xmlObjectToElementTransformer;
        this.samlSignatureSigner = samlSignatureSigner;
        this.samlResponseAssertionEncrypter = samlResponseAssertionEncrypter;
        this.responseAssertionSigner = responseAssertionSigner;
        this.responseSignatureCreator = responseSignatureCreator;
    }

    @Override
    public Element apply(Response response) {
        Response responseWithSignature = this.responseSignatureCreator.addUnsignedSignatureTo(response);
        Response responseWithSignedAssertions = this.responseAssertionSigner.signAssertions(responseWithSignature);
        Response responseWithEncryptedAssertions = this.samlResponseAssertionEncrypter.encryptAssertions(responseWithSignedAssertions);
        Response signedResponse = this.samlSignatureSigner.sign(responseWithEncryptedAssertions);
        return this.xmlObjectToElementTransformer.apply(signedResponse);
    }
}

