/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import java.text.MessageFormat;
import java.util.Optional;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import uk.gov.ida.saml.security.EncryptionCredentialResolver;

public class MetadataBackedEncryptionCredentialResolver
implements EncryptionCredentialResolver {
    private CredentialResolver credentialResolver;
    private QName role;

    public MetadataBackedEncryptionCredentialResolver(CredentialResolver credentialResolver, QName role) {
        this.credentialResolver = credentialResolver;
        this.role = role;
    }

    @Override
    public Credential getEncryptingCredential(String receiverId) {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new EntityIdCriterion(receiverId));
        criteria.add((Object)new EntityRoleCriterion(this.role));
        criteria.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        try {
            return Optional.ofNullable((Credential)this.credentialResolver.resolveSingle((Object)criteria)).orElseThrow(() -> new CredentialMissingInMetadataException(receiverId));
        }
        catch (ResolverException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CredentialMissingInMetadataException
    extends RuntimeException {
        public static final String PATTERN = "No public key for entity-id: \"{0}\" could be found in the metadata. Metadata could be expired, invalid, or missing entities";

        public CredentialMissingInMetadataException(String receivedId) {
            super(MessageFormat.format(PATTERN, receivedId));
        }
    }
}

