/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers.inbound;

import java.util.HashMap;
import java.util.List;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import uk.gov.ida.saml.core.domain.Cycle3Dataset;
import uk.gov.ida.saml.core.extensions.StringBasedMdsAttributeValue;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.hub.errors.SamlTransformationErrorFactory;

public class Cycle3DatasetFactory {
    public Cycle3Dataset createCycle3DataSet(Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements.size() != 1) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingAttributeStatementInAssertion(assertion.getID());
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        List attributes = ((AttributeStatement)attributeStatements.get(0)).getAttributes();
        HashMap<String, String> data = new HashMap<String, String>();
        for (Attribute attribute : attributes) {
            data.put(attribute.getName(), ((StringBasedMdsAttributeValue)attribute.getAttributeValues().get(0)).getValue());
        }
        return Cycle3Dataset.createFromData(data);
    }
}

