/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security.errors;

import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.core.validation.errors.GenericHubProfileValidationSpecification;
import uk.gov.ida.saml.core.validation.errors.SamlValidationSpecification;

public final class SamlTransformationErrorFactory {
    private SamlTransformationErrorFactory() {
    }

    public static SamlValidationSpecificationFailure unableToDeserializeStringToOpenSaml(String message) {
        return new SamlValidationSpecification("Unable to deserialize string into OpenSaml object: {0}", message);
    }

    public static SamlValidationSpecificationFailure emptyIssuer() {
        return new GenericHubProfileValidationSpecification("SAML ''Issuer'' element has no value.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure illegalIssuerFormat(String providedFormat, String expectedFormat) {
        return new GenericHubProfileValidationSpecification("SAML ''Issuer'' has wrong format: {0}, expected {1}.", providedFormat, expectedFormat);
    }

    public static SamlValidationSpecificationFailure unableToDecrypt(String message) {
        return new GenericHubProfileValidationSpecification("Problem decrypting assertion {0}.", message);
    }

    public static SamlValidationSpecificationFailure unableToDecryptXMLEncryptionKey(String algorithm) {
        return new GenericHubProfileValidationSpecification("Unable to decrypt XML encryption key with algorithm {0}.", algorithm);
    }

    public static SamlValidationSpecificationFailure unableToEncryptXMLEncryptionKey() {
        return new GenericHubProfileValidationSpecification("Unable to encrypt XML encryption key.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure unsupportedSignatureEncryptionAlgortithm(String algorithm) {
        return new GenericHubProfileValidationSpecification("Signature algorithm {0} is not supported.", algorithm);
    }

    public static SamlValidationSpecificationFailure unsupportedEncryptionAlgortithm(String algorithm) {
        return new GenericHubProfileValidationSpecification("Assertion encrypted with unsupported encryption algorithm {0}, should be AES128.", algorithm);
    }

    public static SamlValidationSpecificationFailure unableToLocateEncryptedKey() {
        return new GenericHubProfileValidationSpecification("Unable to located encrypted key within assertion.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure unsupportedKeyEncryptionAlgorithm(String algorithm) {
        return new GenericHubProfileValidationSpecification("Key encrypted with unsupported encryption algorithm {0}, should be RSAOAEP.", algorithm);
    }

    public static SamlValidationSpecificationFailure missingSignature() {
        return new GenericHubProfileValidationSpecification("Message has no signature.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure signatureNotSigned() {
        return new GenericHubProfileValidationSpecification("Message signature is not signed", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingIssuer() {
        return new GenericHubProfileValidationSpecification("SAML is missing ''Issuer'' element.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure invalidSignatureForAssertion(String assertionId) {
        return new GenericHubProfileValidationSpecification("Signature for assertion {0} was not valid.", assertionId);
    }

    public static SamlValidationSpecificationFailure invalidMessageSignature() {
        return new GenericHubProfileValidationSpecification("Signature was not valid.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure unableToValidateMessageSignature() {
        return new GenericHubProfileValidationSpecification("Unknown problem when trying to validate signature.", new Object[0]);
    }
}

