/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.saml.saml2.core.Assertion;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationResponse;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.security.SamlMessageSignatureValidator;
import uk.gov.ida.saml.security.validators.ValidatedAssertions;

public class SamlAssertionsSignatureValidator {
    private final SamlMessageSignatureValidator samlMessageSignatureValidator;

    public SamlAssertionsSignatureValidator(SamlMessageSignatureValidator samlMessageSignatureValidator) {
        this.samlMessageSignatureValidator = samlMessageSignatureValidator;
    }

    public ValidatedAssertions validate(List<Assertion> assertions, QName role) {
        for (Assertion assertion : assertions) {
            SamlValidationResponse samlValidationResponse = this.samlMessageSignatureValidator.validate(assertion, role);
            this.checkResponseisOk(samlValidationResponse);
        }
        return new ValidatedAssertions(assertions);
    }

    public ValidatedAssertions validateEidas(List<Assertion> assertions, QName role) {
        for (Assertion assertion : assertions) {
            SamlValidationResponse samlValidationResponse = this.samlMessageSignatureValidator.validateEidasAssertion(assertion, role);
            this.checkResponseisOk(samlValidationResponse);
        }
        return new ValidatedAssertions(assertions);
    }

    private void checkResponseisOk(SamlValidationResponse samlValidationResponse) {
        if (!samlValidationResponse.isOK()) {
            SamlValidationSpecificationFailure failure = samlValidationResponse.getSamlValidationSpecificationFailure();
            if (samlValidationResponse.getCause() != null) {
                throw new SamlTransformationErrorException(failure.getErrorMessage(), samlValidationResponse.getCause(), failure.getLogLevel());
            }
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }
}

