/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import uk.gov.ida.saml.security.CertificateChainEvaluableCriterion;
import uk.gov.ida.saml.security.SignatureValidator;

public class MetadataBackedSignatureValidator
extends SignatureValidator {
    private final ExplicitKeySignatureTrustEngine explicitKeySignatureTrustEngine;
    private final Optional<CertificateChainEvaluableCriterion> certificateChainEvaluableCriteria;

    public static MetadataBackedSignatureValidator withoutCertificateChainValidation(ExplicitKeySignatureTrustEngine explicitKeySignatureTrustEngine) {
        return new MetadataBackedSignatureValidator(explicitKeySignatureTrustEngine);
    }

    public static MetadataBackedSignatureValidator withCertificateChainValidation(ExplicitKeySignatureTrustEngine explicitKeySignatureTrustEngine, CertificateChainEvaluableCriterion certificateChainEvaluableCriterion) {
        return new MetadataBackedSignatureValidator(explicitKeySignatureTrustEngine, certificateChainEvaluableCriterion);
    }

    private MetadataBackedSignatureValidator(ExplicitKeySignatureTrustEngine explicitKeySignatureTrustEngine) {
        this.explicitKeySignatureTrustEngine = explicitKeySignatureTrustEngine;
        this.certificateChainEvaluableCriteria = Optional.empty();
    }

    private MetadataBackedSignatureValidator(ExplicitKeySignatureTrustEngine explicitKeySignatureTrustEngine, CertificateChainEvaluableCriterion certificateChainEvaluableCriterion) {
        this.explicitKeySignatureTrustEngine = explicitKeySignatureTrustEngine;
        this.certificateChainEvaluableCriteria = Optional.of(certificateChainEvaluableCriterion);
    }

    @Override
    protected List<Criterion> getAdditionalCriteria(String entityId, QName role) {
        ArrayList<Criterion> criteriaSet = new ArrayList<Criterion>();
        criteriaSet.add((Criterion)new EntityIdCriterion(entityId));
        criteriaSet.add((Criterion)new EntityRoleCriterion(role));
        criteriaSet.add((Criterion)new UsageCriterion(UsageType.SIGNING));
        this.certificateChainEvaluableCriteria.map(criteriaSet::add);
        return criteriaSet;
    }

    @Override
    protected TrustEngine<Signature> getTrustEngine(String entityId) {
        return this.explicitKeySignatureTrustEngine;
    }
}

