/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import uk.gov.ida.saml.security.SignatureValidator;
import uk.gov.ida.saml.security.SigningCredentialFactory;

public class CredentialFactorySignatureValidator
extends SignatureValidator {
    private final SigningCredentialFactory credentialFactory;

    public CredentialFactorySignatureValidator(SigningCredentialFactory credentialFactory) {
        this.credentialFactory = credentialFactory;
    }

    @Override
    protected List<Criterion> getAdditionalCriteria(String entityId, QName role) {
        return Arrays.asList(new Criterion(){});
    }

    @Override
    protected TrustEngine<Signature> getTrustEngine(String entityId) {
        List<Credential> credentials = this.credentialFactory.getVerifyingCredentials(entityId);
        StaticCredentialResolver credResolver = new StaticCredentialResolver(credentials);
        KeyInfoCredentialResolver kiResolver = DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver();
        return new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, kiResolver);
    }
}

